//
// NAME: CIDLib_Handle.Hpp
//
// DESCRIPTION:
//
//  This is the header for the CIDLib_Handle.Cpp module, which implements
//  the TOSHandle class. This is a very simple class and is just for the
//  formatting of handles to streams. Normally, if you try to format a
//  handle to a stream, it misinterprets this in one way or another
//  according to the available formatting overrides available. This class
//  just makes sure that it comes out with the correct format and in hex
//  radix. We could use TCardinal for this, but we don't want to assume
//  always that a handle and a TCardinal are the same size or have the
//  same formatting issues.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 08/01/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//  CLASS: TOSHandle
// PREFIX: h
// ----------------------------------------------------------------------------
class CIDLIBEXP TOSHandle :

    public TObject, public MFormattable, public MDuplicable
{
    public  :
        // --------------------------------------------------------------------
        // Constructors and Destructors
        // --------------------------------------------------------------------
        TOSHandle();

        TOSHandle
        (
            const   TOSHandle&              hToCopy
        );

        TOSHandle
        (
            const   tCIDLib::THandle        hToWrap
        );

        ~TOSHandle();


        // --------------------------------------------------------------------
        //  Public operators
        // --------------------------------------------------------------------
        TOSHandle& operator=
        (
            const   TOSHandle&              hToAssign
        );

        tCIDLib::TBoolean operator==
        (
            const   TOSHandle&              hToCompare
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   TOSHandle&              hToCompare
        )   const;



    protected :
        // --------------------------------------------------------------------
        //  Protected, inherited methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmDest
        )   const;


    private :
        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __hData
        //      This is the handle that we are to format
        // --------------------------------------------------------------------
        tCIDLib::THandle    __hData;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TOSHandle,TObject)
        DefPolyDup(TOSHandle)
};

#pragma pack(pop)



// ----------------------------------------------------------------------------
//  Constructors and destructors
// ----------------------------------------------------------------------------
inline TOSHandle::TOSHandle() :

    __hData(0)
{
}

inline TOSHandle::TOSHandle(const TOSHandle& hToCopy) :

    __hData(hToCopy.__hData)
{
}

inline TOSHandle::TOSHandle(const tCIDLib::THandle hToWrap) :

    __hData(hToWrap)
{
}

inline TOSHandle::~TOSHandle()
{
}


// ----------------------------------------------------------------------------
//  Public operators
// ----------------------------------------------------------------------------
inline TOSHandle& TOSHandle::operator=(const TOSHandle& hToAssign)
{
    __hData = hToAssign.__hData;
    return *this;
}

inline tCIDLib::TBoolean
TOSHandle::operator==(const TOSHandle& hToCompare) const
{
    return (__hData == hToCompare.__hData);
}

inline tCIDLib::TBoolean
TOSHandle::operator!=(const TOSHandle& hToCompare) const
{
    return (__hData != hToCompare.__hData);
}
