//
// NAME: CIDLib_Handle.Cpp
//
// DESCRIPTION:
//
//  This module implements the TOSHandle class. Most of it is inline because
//  its very simple.
//
//
//  AUTHOR: Dean Roddey
//
//  CREATE DATE: 07/02/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//


// ----------------------------------------------------------------------------
//  Facility specific includes
// ----------------------------------------------------------------------------
#include    "CIDLib_.Hpp"


// ----------------------------------------------------------------------------
//  Do our standard RTTI macros
// ----------------------------------------------------------------------------
RTTIData2(TOSHandle,TObject)


// ----------------------------------------------------------------------------
//   CLASS: TOSHandle
//  PREFIX: h
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  TOSHandle: Protected, inherited methods
// ----------------------------------------------------------------------------

tCIDLib::TVoid TOSHandle::_FormatTo(TTextStream& strmToWriteTo) const
{
    // Do the conversion into a temporary string
    tCIDLib::TZStr32    szTmp;
    TRawStr::FormatVal(tCIDLib::TCard4(__hData), szTmp, 32, tCIDLib::ERadix_Hex);

    // And append the formatted string to the passed stream
    strmToWriteTo << szTmp;
}
