//
// NAME: CIDLib_Formattable.Hpp
//
// DESCRIPTION: 
//
//  This header implments the mixin class, MFormattable, which bestows
//  upon its mixed into classes the ability to be formatted to a text
//  stream.
//
//  A global operator<< is provided here that will allow any formattable
//  object to be formatted to a text stream.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 09/24/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// ----------------------------------------------------------------------------
//  Forward references
// ----------------------------------------------------------------------------
class   TTextStream;


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//  CLASS: MFormattable
// PREFIX: fmtbl
// ----------------------------------------------------------------------------
class CIDLIBEXP MFormattable
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        MFormattable() {}

        ~MFormattable() {}


    protected   :
        // --------------------------------------------------------------------
        //  Declare our friends
        //
        //  The global methods below must have access to our protected stream
        //  methods.
        // --------------------------------------------------------------------
        friend TTextStream& operator<<
        (
                    TTextStream&            strmToWriteTo
            , const MFormattable&           fmtblToWrite
        );


        // --------------------------------------------------------------------
        //  Protected virtual methods
        // --------------------------------------------------------------------
        virtual tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmDest
        )   const = 0;


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        MFormattable(const MFormattable&);

        tCIDLib::TVoid operator=(const MFormattable&);
};

#pragma pack(pop)



// ----------------------------------------------------------------------------
//  Provide the global operators that allow any streamable object to be
//  read from or written to a text stream. This is what the outside world
//  uses.
// ----------------------------------------------------------------------------
inline TTextStream&
operator<<(TTextStream& strmToWriteTo, const MFormattable& fmtblToWrite)
{
    fmtblToWrite._FormatTo(strmToWriteTo);
    return strmToWriteTo;
}
