//
// NAME: CIDLib_Float.Hpp
//
// DESCRIPTION:
//
//  This is the definition file for the CIDLib_Float.Cpp module. This module
//  implements a class wrapper for a 64 bit floating point value. Its a very
//  simple class and makes no attempt to create a fully mathematical
//  functional class. Its purely for formatting purposes and for when an
//  floating point value needs to act like an object.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 04/15/93
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


// ----------------------------------------------------------------------------
//  Forward references
// ----------------------------------------------------------------------------
class   TCardinal;
class   TInteger;


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//  CLASS: TFloat
// PREFIX: f
//
//  This class provides a double floating point value
// ----------------------------------------------------------------------------
class CIDLIBEXP TFloat :

    public TObject, public MFormattable, public MDuplicable, public MStreamable
{
    public  :
        // --------------------------------------------------------------------
        // Constructors and Destructors
        // --------------------------------------------------------------------
        TFloat();

        TFloat
        (
            const   TFloat&                 fToCopy
        );

        TFloat
        (
            const   tCIDLib::TFloat8        f8Val
            , const tCIDLib::TCard1         c1Precision = 2
            , const tCIDLib::ETrailFormats  eStyle = tCIDLib::ETrail_Zeroes
        );

        TFloat
        (
            const   tCIDLib::TInt8          i8Val
            , const tCIDLib::TCard1         c1Precision = 0
            , const tCIDLib::ETrailFormats  eStyle = tCIDLib::ETrail_Zeroes
        );

        TFloat
        (
            const   tCIDLib::TCard4         c4Val
            , const tCIDLib::TCard1         c1Precision = 0
            , const tCIDLib::ETrailFormats  eStyle = tCIDLib::ETrail_Zeroes
        );

        TFloat
        (
            const   tCIDLib::TInt4          i4Val
            , const tCIDLib::TCard1         c1Precision = 0
            , const tCIDLib::ETrailFormats  eStyle = tCIDLib::ETrail_Zeroes
        );

        ~TFloat();


        // --------------------------------------------------------------------
        //  Public operators
        // --------------------------------------------------------------------
        operator tCIDLib::TFloat8() const;

        TFloat& operator=
        (
            const   TFloat&                 fToAssign
        );

        TFloat& operator=
        (
            const   tCIDLib::TFloat8        f8ToAssign
        );

        tCIDLib::TBoolean operator==
        (
            const   TFloat&                 fToTest
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   TFloat&                 fToTest
        )   const;

        tCIDLib::TBoolean operator==
        (
            const   tCIDLib::TFloat8        f8ToTest
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   tCIDLib::TFloat8        f8ToTest
        )   const;

        tCIDLib::TBoolean operator<
        (
            const   TFloat&                 fToTest
        )   const;

        tCIDLib::TBoolean operator<=
        (
            const   TFloat&                 fToTest
        )   const;

        tCIDLib::TBoolean operator>
        (
            const   TFloat&                 fToTest
        )   const;

        tCIDLib::TBoolean operator>=
        (
            const   TFloat&                 fToTest
        )   const;


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TCard1 c1Precision() const;

        tCIDLib::TCard1 c1Precision
        (
            const   tCIDLib::TCard1         c1Precision
        );

        tCIDLib::ETrailFormats eTrailingStyle() const;

        tCIDLib::ETrailFormats eTrailingStyle
        (
            const   tCIDLib::ETrailFormats  eStyle
        );

        tCIDLib::TFloat8 f8Val() const;

        tCIDLib::TFloat8 f8Val
        (
            const   tCIDLib::TFloat8        f8NewVal
        );

    protected   :
        // --------------------------------------------------------------------
        //  Protected, inherited methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmDest
        )   const;

        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&             strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&             strmToWriteTo
        )   const;


    private :
        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __c4Precision
        //      This is the number of decimal places when formatting
        //
        //  __eTrailingStyle
        //      Indicates whether insignficant trailing zeros should be
        //      formatted as zeros, spaces, or ignored.
        //
        //  __f8Val
        //      Storage for the data value
        // --------------------------------------------------------------------
        tCIDLib::TCard1         __c4Precision;
        tCIDLib::ETrailFormats  __eTrailingStyle;
        tCIDLib::TFloat8        __f8Val;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TFloat,TObject)
        DefPolyDup(TFloat)
};



// ----------------------------------------------------------------------------
//  CLASS: TLocFloat
// PREFIX: f
//
//  This class provides a double floating point value
// ----------------------------------------------------------------------------
class CIDLIBEXP TLocFloat : public TFloat
{
    public  :
        // --------------------------------------------------------------------
        // Constructors and Destructors
        // --------------------------------------------------------------------
        TLocFloat();

        TLocFloat
        (
            const   tCIDLib::TFloat8        f8Val
            , const tCIDLib::TCard1         c1Precision = 2
        );

        TLocFloat
        (
            const   TLocFloat&              fToCopy
        );

        ~TLocFloat();


        // --------------------------------------------------------------------
        //  Public operators
        // --------------------------------------------------------------------
        TLocFloat& operator=
        (
            const   TLocFloat&              fToAssign
        );

        tCIDLib::TBoolean operator==
        (
            const   TLocFloat&              fToTest
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   TLocFloat&              fToCompare
        )   const;

        tCIDLib::TBoolean operator<
        (
            const   TLocFloat&              fToCompare
        )   const;

        tCIDLib::TBoolean operator<=
        (
            const   TLocFloat&              fToCompare
        )   const;

        tCIDLib::TBoolean operator>
        (
            const   TLocFloat&              fToCompare
        )   const;

        tCIDLib::TBoolean operator>=
        (
            const   TLocFloat&              fToCompare
        )   const;


    protected   :
        // --------------------------------------------------------------------
        //  Protected, inherited methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmDest
        )   const;


    private :
        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TLocFloat,TFloat)
        DefPolyDup(TLocFloat)
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  TFloat: Constructors and destrutors
// ----------------------------------------------------------------------------
inline TFloat::~TFloat()
{
}


// ----------------------------------------------------------------------------
//  TFloat: Public operators
// ----------------------------------------------------------------------------
inline TFloat::operator tCIDLib::TFloat8() const
{
    return __f8Val;
}

inline TFloat& TFloat::operator=(const tCIDLib::TFloat8 f8NewVal)
{
    __f8Val = f8NewVal;
    return *this;
}

inline tCIDLib::TBoolean TFloat::operator!=(const TFloat& fToTest) const
{
    return !operator==(fToTest);
}

inline tCIDLib::TBoolean TFloat::operator==(const tCIDLib::TFloat8 f8ToTest) const
{
    return (f8ToTest == __f8Val);
}

inline tCIDLib::TBoolean TFloat::operator!=(const tCIDLib::TFloat8 f8ToTest) const
{
    return (f8ToTest != __f8Val);
}

inline tCIDLib::TBoolean TFloat::operator<(const TFloat& fToTest) const
{
    return (__f8Val < fToTest.__f8Val);
}

inline tCIDLib::TBoolean TFloat::operator<=(const TFloat& fToTest) const
{
    return (__f8Val <= fToTest.__f8Val);
}

inline tCIDLib::TBoolean TFloat::operator>(const TFloat& fToTest) const
{
    return (__f8Val > fToTest.__f8Val);
}

inline tCIDLib::TBoolean TFloat::operator>=(const TFloat& fToTest) const
{
    return (__f8Val >= fToTest.__f8Val);
}


// ----------------------------------------------------------------------------
//  TFloat: Public, non-virtual methods
// ----------------------------------------------------------------------------
inline tCIDLib::TCard1 TFloat::c1Precision() const
{
    return __c4Precision;
}

inline tCIDLib::TCard1 TFloat::c1Precision(const tCIDLib::TCard1 c1Precision)
{
    __c4Precision = c1Precision;
    return __c4Precision;
}

inline tCIDLib::ETrailFormats TFloat::eTrailingStyle() const
{
    return __eTrailingStyle;
}

inline tCIDLib::ETrailFormats
TFloat::eTrailingStyle(const tCIDLib::ETrailFormats eStyle)
{
    __eTrailingStyle = eStyle;
    return eStyle;
}

inline tCIDLib::TFloat8 TFloat::f8Val() const
{
    return __f8Val;
}

inline tCIDLib::TFloat8 TFloat::f8Val(const tCIDLib::TFloat8 f8NewVal)
{
    __f8Val = f8NewVal;
    return __f8Val;
}



// ----------------------------------------------------------------------------
//  TLocFloat: Constructors and destrutors
// ----------------------------------------------------------------------------
inline TLocFloat::TLocFloat()
{
}

inline TLocFloat::TLocFloat(const   tCIDLib::TFloat8    f8Val
                            , const tCIDLib::TCard1     c1Precision) :

    TFloat(f8Val, c1Precision, tCIDLib::ETrail_Zeroes)
{
}

inline TLocFloat::TLocFloat(const TLocFloat& fToCopy) :

    TFloat(fToCopy)
{
}

inline TLocFloat::~TLocFloat()
{
}

// ----------------------------------------------------------------------------
//  TLocFloat: Public operators
// ----------------------------------------------------------------------------
inline tCIDLib::TBoolean TLocFloat::operator==(const TLocFloat& fToTest) const
{
    return TParent::operator==(fToTest);
}

inline tCIDLib::TBoolean TLocFloat::operator!=(const TLocFloat& fToTest) const
{
    return !TParent::operator==(fToTest);
}

inline tCIDLib::TBoolean TLocFloat::operator<(const TLocFloat& cComp) const
{
    return TParent::operator<(cComp);
}

inline tCIDLib::TBoolean TLocFloat::operator<=(const TLocFloat& cComp) const
{
    return TParent::operator<=(cComp);
}

inline tCIDLib::TBoolean TLocFloat::operator>(const TLocFloat& cComp) const
{
    return TParent::operator>(cComp);
}

inline tCIDLib::TBoolean TLocFloat::operator>=(const TLocFloat& cComp) const
{
    return TParent::operator>=(cComp);
}
