//
// NAME: CIDLib_FileSystem.Hpp
//
// DESCRIPTION:
//
//  This module implements the TFileSys class, which provides directory
//  searching, volume management, and those file operations that are
//  performed on files when they are closed such as rename, copy, delete,
//  attribute management, etc...
//
//
// AUTHOR: Dean Roddey
//
// CREATE TDate: 06/12/93
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//



#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//   CLASS: TFileSys
//  PREFIX: flsys
// -----------------------------------------------------------------------------
class CIDLIBEXP TFileSys : public TObject
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors
        // ---------------------------------------------------------------------
        TFileSys();

        ~TFileSys();


        // ---------------------------------------------------------------------
        //  Public, static methods
        // ---------------------------------------------------------------------
        static tCIDLib::TBoolean bExists
        (
            const   TString&                strSpec
        );

        static tCIDLib::TBoolean bExists
        (
            const   TString&                strDirectory
            , const TString&                strName
        );

        static tCIDLib::TBoolean bExists
        (
            const   TString&                strSpec
            , const tCIDLib::EFileAttrs     eCanBe
            , const tCIDLib::EFileAttrs     eMustBe = tCIDLib::EFileAttr_None
        );

        static tCIDLib::TBoolean bExists
        (
            const   TString&                strDirectory
            , const TString&                strName
            , const tCIDLib::EFileAttrs     eCanBe
            , const tCIDLib::EFileAttrs     eMustBe = tCIDLib::EFileAttr_None
        );

        static tCIDLib::TBoolean bExists
        (
            const   TString&                strSpec
            , const tCIDLib::EFileAttrs     eCanBe
            , const tCIDLib::EFileAttrs     eMustBe
            ,       TFindBuf&               fndbToFill
        );

        static tCIDLib::TBoolean bExists
        (
            const   TString&                strDirectory
            , const TString&                strName
            , const tCIDLib::EFileAttrs     eCanBe
            , const tCIDLib::EFileAttrs     eMustBe
            ,       TFindBuf&               fndbToFill
        );

        static tCIDLib::TBoolean bExistsInPath
        (
            const   TString&                strSpec
            , const TString&                strSearchPath
        );

        static tCIDLib::TBoolean bExistsInPath
        (
            const   TString&                strSpec
            , const TString&                strSearchPath
            , const tCIDLib::EFileAttrs     eCanBe
            , const tCIDLib::EFileAttrs     eMustBe = tCIDLib::EFileAttr_None
        );

        static tCIDLib::TBoolean bExistsInPath
        (
            const   TString&                strSpec
            , const TString&                strSearchPath
            , const tCIDLib::EFileAttrs     eCanBe
            , const tCIDLib::EFileAttrs     eMustBe
            ,       TFindBuf&               fndTarget
        );

        static tCIDLib::TBoolean bIsDirectory
        (
            const   TString&                strPath
        );

        static tCIDLib::TCard4 c4BuildDirTree
        (
            const   TString&                strWildCard
            ,       TFindBuf&               colMatches
        );

        static tCIDLib::TCard4 c4BuildFileTree
        (
            const   TString&                strWildCard
            ,       TFindBuf&               colMatches
            , const tCIDLib::EFileAttrs     eCanBe = tCIDLib::EFileAttr_All
            , const tCIDLib::EFileAttrs     eMustBe = tCIDLib::EFileAttr_None
        );

        static tCIDLib::TCard4 c4QueryAvailableVolumePaths
        (
                    TCollection<TString>&   colToFill
        );

        static tCIDLib::TCard4 c4QueryAvailableVolumes
        (
                    TCollection<TVolumeInfo>& colToFill
        );

        static tCIDLib::TCard4 c4SearchDir
        (
            const   TString&                strSpec
            ,       TCollection<TFindBuf>&  colTarget
            , const tCIDLib::EFileAttrs     eCanBe = tCIDLib::EFileAttr_All
            , const tCIDLib::EFileAttrs     eMustBe = tCIDLib::EFileAttr_None
        );

        static tCIDLib::TCard4 c4SearchDir
        (
            const   TString&                strPath
            , const TString&                strWildCard
            ,       TCollection<TFindBuf>&  colTarget
            , const tCIDLib::EFileAttrs     eCanBe = tCIDLib::EFileAttr_All
            , const tCIDLib::EFileAttrs     eMustBe = tCIDLib::EFileAttr_None
        );

        static tCIDLib::TVoid CopyFile
        (
            const   TString&                strSourcePath
            , const TString&                strTargetPath
            , const tCIDLib::TBoolean       bFailIfExists = kCIDLib::False
        );

        static tCIDLib::TVoid DeleteFile
        (
            const   TString&                strSpec
        );

        static tCIDLib::TVoid DeleteFile
        (
            const   TString&                strDirectory
            , const TString&                strName
        );

        static tCIDLib::TVoid MakeDirectory
        (
            const   TString&                strToCreate
            , const TString&                strTemplatePath = NUL_TString
        );

        static tCIDLib::TVoid MakeSubDirectory
        (
            const   TString&                strToCreate
            , const TString&                strParent
            , const TString&                strTemplatePath = NUL_TString
        );

        static tCIDLib::TVoid QueryCurrentDir
        (
                    TString&                strToFill
        );

        static tCIDLib::TVoid QueryFullPath
        (
            const   TString&                strPartialPath
            ,       TString&                strFullReturnedPath
        );

        static tCIDLib::TVoid QueryVolumeLabel
        (
                    TString&                strToFill
            ,       TString&                strSerialNumber
            , const TString&                strVolumePath
        );

        static tCIDLib::TVoid RemovePath
        (
            const   TString&                strStartDir
        );

        static tCIDLib::TVoid RemoveDirectory
        (
            const   TString&                strSpec
        );

        static tCIDLib::TVoid Rename
        (
            const   TString&                strSource
            , const TString&                strDest
        );


    protected   :
        // ---------------------------------------------------------------------
        //  Protected, static methods
        // ---------------------------------------------------------------------
        static tCIDLib::TVoid _FindDirs
        (
            const   TString&                strWildCard
            ,       TFindBuf&               fndbTarget
            ,       tCIDLib::TCard4&        c4Matches
        );

        static tCIDLib::TVoid _FindFiles
        (
            const   TString&                strWildCard
            ,       TFindBuf&               fndbTarget
            ,       tCIDLib::TCard4&        c4Matches
            , const tCIDLib::EFileAttrs     eCanBe = tCIDLib::EFileAttr_All
            , const tCIDLib::EFileAttrs     eMustBe = tCIDLib::EFileAttr_None
        );


    private :
        // ---------------------------------------------------------------------
        //  Hidden constructors/operators
        // ---------------------------------------------------------------------
        TFileSys(const TFileSys&);

        tCIDLib::TVoid operator=(const TFileSys&);


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TFileSys,TObject)
};

#pragma pack(pop)
