//
// NAME: CIDLib_FileLogger.Hpp
//
// DESCRIPTION:
//
//  This is the header file for the CIDLib_FileLogger.Cpp module. This
//  module provides a simple derivative of TLogger, and supports logging
//  to a binary output file. It optionally supports a named mutex to
//  control logging by multiple processes. It does not have to worry about
//  multiple threads within the same process because calls to LogMsg()
//  are already synchronized by the calling thread in TFacility.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 11/27/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
//  CAVEATS/GOTCHAS:
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//  CLASS: TFileLogger
// PREFIX: lgr
// ----------------------------------------------------------------------------
class CIDLIBEXP TFileLogger : public TLogger
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors.
        // --------------------------------------------------------------------
        TFileLogger();

        TFileLogger
        (
            const   tCIDLib::Tch* const     pszFile
            , const TResourceName&          rsnMutex = NUL_TResourceName
        );

        ~TFileLogger();


        // ---------------------------------------------------------------------
        //  Public, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid LogMsg
        (
            const   TError&                 errToLog
        );


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid Create
        (
            const   tCIDLib::Tch* const     pszFile
            , const TResourceName&          rsnMutex
        );


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TFileLogger(const TFileLogger&);

        tCIDLib::TVoid operator=(const TFileLogger&);


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __flTarget
        //      This is a file object for the target file.
        //
        //  __pmtxSync
        //      This is the optional named mutex that is used to sync
        //      multiple processes logging to the same file. If one was not
        //      provided, then no cross process synchronization is used.
        // --------------------------------------------------------------------
        TBinaryFile     __flTarget;
        TMutex*         __pmtxSync;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TFileLogger,TLogger)
};

#pragma pack(pop)
