//
// NAME: CIDLib_FileBase.Hpp
//
// DESCRIPTION:
//
//  This module implements the TFileBase class. TFileBase is an abstract class
//  that is the basis of all file classes. There are a good many information
//  and control methods that can be done to any file so they are included
//  here. Some methods are protected and are only exposed by derivatives for
//  which they are legal. This class uses the TKrnlFile class as its mechanism
//  for accessing host file services.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/22/93
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//   CLASS: TFileBase
//  PREFIX: fbase
// -----------------------------------------------------------------------------
class CIDLIBEXP TFileBase : public TObject
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors
        // ---------------------------------------------------------------------
        TFileBase();

        TFileBase
        (
            const   TString&                strFileName
        );

        TFileBase
        (
            const   tCIDLib::Tch* const     pszFileName
        );

        ~TFileBase();


        // ---------------------------------------------------------------------
        //  Public operators
        // ---------------------------------------------------------------------
        operator const TKrnlFile&() const;

        operator TKrnlFile&();


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TBoolean bEndOfFile();

        tCIDLib::TBoolean bExists
        (
            const   tCIDLib::EFileAttrs     eCanBe
            , const tCIDLib::EFileAttrs     eMustBe = tCIDLib::EFileAttr_None
        )   const;

        tCIDLib::TBoolean bExists
        (
            const   tCIDLib::EFileAttrs     eAttrs
            , const tCIDLib::EFileAttrs     eMustBe
            ,       tCIDLib::TBoolean&      bUnique
        )   const;

        tCIDLib::TBoolean bIsOpen() const;

        tCIDLib::TVoid Close();

        tCIDLib::TFilePos fposQueryCurPos();

        tCIDLib::TFilePos fposQuerySize();

        const TKrnlFile& kflThis() const;

        TKrnlFile& kflThis();

        tCIDLib::TVoid Open
        (
            const   tCIDLib::EAccessModes   eAccess
            , const tCIDLib::ECreateActions eAction
            , const tCIDLib::EFileAttrs     eAttrs
            , const tCIDLib::EFileFlags     eFlags
        );

        tCIDLib::TVoid Open
        (
            const   tCIDLib::EStdFiles      eStdFile
        );

        const TString& strName() const;

        const TString& strName
        (
            const   TString&                strNew
        );

        tCIDLib::TVoid TruncateAt
        (
            const   tCIDLib::TFilePos       fposPosition
        );

        tCIDLib::TVoid TruncateAt();


    protected   :
        // ---------------------------------------------------------------------
        //  Protected, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _ReadBuf
        (
                    tCIDLib::TVoid* const   pBuf
            , const tCIDLib::TCard4         c4BufSz
            ,       tCIDLib::TCard4&        c4Actual
        );

        tCIDLib::TVoid _Seek
        (
            const   tCIDLib::TFilePos       fposOffset
            , const tCIDLib::ESeekFrom      eSeekFrom = tCIDLib::ESeekFrom_Start
            ,       tCIDLib::TFilePos&      fposActual  = NUL_TFilePos
        );

        tCIDLib::TVoid _WriteBuf
        (
            const   tCIDLib::TVoid* const   pBuf
            , const tCIDLib::TCard4         c4BufSz
            ,       tCIDLib::TCard4&        c4Actual
        );


    private         :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        TFileBase(const TFileBase&);

        tCIDLib::TVoid operator=(const TFileBase&);


        // ---------------------------------------------------------------------
        //  Protected data members
        //
        //  __kflThis
        //      This the kernel file object that represents the file in a
        //      platform independent way.
        //
        //  __strName
        //      This is used to store the name of the file. It is stored just
        //      as it is provided by the creator, which may mean a relative
        //      path. The caller is responsible for making sure that the
        //      current directory is the correct base for the relative path
        //      given.
        // ---------------------------------------------------------------------
        TKrnlFile           __kflThis;
        TString             __strName;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TFileBase,TObject)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  Public operators
// -----------------------------------------------------------------------------
inline TFileBase::operator const TKrnlFile&() const
{
    return __kflThis;
}

inline TFileBase::operator TKrnlFile&()
{
    return __kflThis;
}


// -----------------------------------------------------------------------------
//  Some inlines for TFileBase
// -----------------------------------------------------------------------------
inline tCIDLib::TBoolean TFileBase::bIsOpen() const
{
    return __kflThis.bValid();
}

inline const TKrnlFile& TFileBase::kflThis() const
{
    return __kflThis;
}

inline TKrnlFile& TFileBase::kflThis()
{
    return __kflThis;
}

inline const TString& TFileBase::strName() const
{
    return __strName;
}
