//
// NAME: CIDLib_Facility.Cpp
//
// DESCRIPTION:
//
//  TFacility is the basic facility class. All other Facility Classes are derived
//  from this guy. It makes sure that all Facilities provide a basic public API,
//  and it does a lot of the grunt work.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 11/25/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//


// ----------------------------------------------------------------------------
//  Facility specific includes
// ----------------------------------------------------------------------------
#include    "CIDLib_.Hpp"


// ----------------------------------------------------------------------------
//  Do our RTTI macros
// ----------------------------------------------------------------------------
RTTIData(TFacility,TObject)


// ----------------------------------------------------------------------------
//  Local static data
//
//  __pszVersionFormat
//      This is the format string for the version member. The provided maj/min
//      version values are formatted into it during construction.
// ----------------------------------------------------------------------------
static const tCIDLib::Tch* const    __pszVersionFormat = L"%(1).%(2,3,0)";




// ----------------------------------------------------------------------------
//   CLASS: TFacility
//  PREFIX: fac
//
//  This is the basic Facility Class. Every DLL Facility must derive a new
//  Facility Class from this one and export a single instance of it to client
//  apps.
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  TFacility: Constructors and Destructors
// ----------------------------------------------------------------------------

TFacility::TFacility(   const   TString&            strFacName
                        , const tCIDLib::EModTypes  eModType
                        , const tCIDLib::TCard4     c4MajVer
                        , const tCIDLib::TCard4     c4MinVer
                        , const tCIDLib::TBoolean   bLoad) :

    TModule(strFacName, eModType, bLoad)
    , __c4MajVer(c4MajVer)
    , __c4MinVer(c4MinVer)
    , __strVersion(__pszVersionFormat)
{
    // Format the version
    __strVersion.ReplaceToken(__c4MajVer, L'1');
    __strVersion.ReplaceToken(__c4MinVer, L'2');
}

TFacility::TFacility(   const   tCIDLib::TModHandle hmodFac
                        , const tCIDLib::EModTypes  eModType
                        , const tCIDLib::TCard4     c4MajVer
                        , const tCIDLib::TCard4     c4MinVer
                        , const tCIDLib::EAdoptOpts eAdopt
                        , const tCIDLib::TBoolean   bViaLoad) :

    TModule(hmodFac, eModType, eAdopt, bViaLoad)
    , __c4MajVer(c4MajVer)
    , __c4MinVer(c4MinVer)
    , __strVersion(__pszVersionFormat)
{
    // Format the version
    __strVersion.ReplaceToken(__c4MajVer, L'1');
    __strVersion.ReplaceToken(__c4MinVer, L'2');
}

TFacility::~TFacility()
{
}
