//
// NAME: CIDLib_ExternalProcess.Hpp
//
// DESCRIPTION:
//
//  This is the header for the CIDLib_ExternalProcess.Cpp module. This module
//  implements the TExternalProcess class. This class allows you to execute
//  other processes and control them.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 09/13/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//


// ----------------------------------------------------------------------------
//  Forward declarations
// ----------------------------------------------------------------------------
template <class TString> class TCollection;


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TExternalProcess
//  PREFIX: extp
// ----------------------------------------------------------------------------
class CIDLIBEXP TExternalProcess : public TObject
{
    public  :
        // --------------------------------------------------------------------
        //  Constuctors and Destructors
        // --------------------------------------------------------------------
        TExternalProcess();

        TExternalProcess
        (
            const   TString&                strPath
            , const TEnvironment&           envToUse
        );

        TExternalProcess
        (
            const   TString&                strPath
        );

        ~TExternalProcess();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TBoolean bIsRunning() const;

        const TEnvironment& envThis() const;

        TEnvironment& envThis();

        tCIDLib::EPrioClasses ePriorityClass() const;

        tCIDLib::EPrioClasses ePriorityClass
        (
            const   tCIDLib::EPrioClasses   eNewClass
        );

        tCIDLib::EExitCodes eWaitForDeath
        (
            const   tCIDLib::TCard4         c4MilliSecs = kCIDLib::c4MaxWait
        )   const;


        tCIDLib::TVoid Kill();

        tCIDLib::TVoid Start
        (
            const   tCIDLib::TBoolean       bDetached = kCIDLib::False
        );

        tCIDLib::TVoid Start
        (
            const   TString&                strNewPath
            , const tCIDLib::TBoolean       bDetached = kCIDLib::False
        );

        tCIDLib::TVoid Start
        (
            const   TString&                strNewPath
            , const TCollection<TString>&   colParms
            , const tCIDLib::TBoolean       bDetached = kCIDLib::False
        );

        tCIDLib::TVoid Start
        (
            const   TString&                strNewPath
            , const TCollection<TString>&   colParms
            , const TEnvironment&           envNew
            , const tCIDLib::TBoolean       bDetached = kCIDLib::False
        );


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        tCIDLib::TVoid operator=(const TExternalProcess&);

        TExternalProcess(const TExternalProcess&);


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __envThis
        //      This is the environment to pass. If the user does not pass
        //      one on construction, then it defaults to this process'
        //      environment.
        //
        //  __kextpThis
        //      This is the kernel abstraction for an external process we
        //      do most of our work via this object. It keeps platform
        //      details down in the kernel where it belongs.
        //
        //  __strPath
        //      This is the path to the Exe file to execute.
        // --------------------------------------------------------------------
        TEnvironment        __envThis;
        TKrnlExtProcess     __kextpThis;
        TString             __strPath;


        // --------------------------------------------------------------------
        //  Magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TExternalProcess, TObject)
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  Public, non-virtual methods
// ----------------------------------------------------------------------------
inline const TEnvironment& TExternalProcess::envThis() const
{
    return __envThis;
}
