//
// NAME: CIDLib_Event.Hpp
//
// DESCRIPTION:
//
//  This is the header for the CIDLib_Event.Cpp module. It implements the
//  TEvent class, which provides a traditional event semaphore. Events can
//  be auto or manual reset and named or unnamed.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 05/23/93
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//  CLASS: TEvent
// PREFIX: ev
// ----------------------------------------------------------------------------
class CIDLIBEXP TEvent : public TObject, public MFormattable
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors.
        // --------------------------------------------------------------------
        TEvent
        (
            const   tCIDLib::EEventStates   eInitState = tCIDLib::EEventState_Triggered
            , const tCIDLib::EAutoModes     eAutoReset = tCIDLib::EAutoMode_Manual
            , const tCIDLib::EShareStates   eShareState = tCIDLib::EShareState_Unshared
        );

        TEvent
        (
            const   TResourceName&          rsnToUse
            , const tCIDLib::EAutoModes     eAutoReset = tCIDLib::EAutoMode_Manual
            , const tCIDLib::EEventStates   eInitState = tCIDLib::EEventState_Reset
            , const tCIDLib::ECreateActions eCreateAct = tCIDLib::ECreateAct_OpenOrCreate
        );

        ~TEvent();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TBoolean bNamed() const;

        tCIDLib::EAutoModes eResetMode() const;

        tCIDLib::EShareStates eShareState() const;

        tCIDLib::TVoid Pulse();

        tCIDLib::TVoid Reset();

        const TResourceName& rsnName() const;

        tCIDLib::TVoid Trigger();

        tCIDLib::TVoid WaitFor
        (
            const   tCIDLib::TCard4         c4Timeout = kCIDLib::c4MaxWait
        );


    protected   :
        // --------------------------------------------------------------------
        //  Protected, inherited methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmToWriteTo
        )   const;


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TEvent(const TEvent&);

        tCIDLib::TVoid operator=(const TEvent&);


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __bNamed
        //      This is set if the event is named or not.
        //
        //  __kevImpl
        //      This is the kernel event object that provides the real
        //      implementation and platform abstraction.
        //
        //  __rsnThis
        //      The name of the event, stored in a resource name object.
        // --------------------------------------------------------------------
        tCIDLib::TBoolean   __bNamed;
        TKrnlEvent          __kevImpl;
        TResourceName       __rsnThis;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TEvent,TObject)
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  Public, inherited methods
// ----------------------------------------------------------------------------
inline tCIDLib::TBoolean TEvent::bNamed() const
{
    return __bNamed;
}

inline tCIDLib::EShareStates TEvent::eShareState() const
{
    return __kevImpl.eShareState();
}

inline const TResourceName& TEvent::rsnName() const
{
    return __rsnThis;
}
