//
// NAME: CIDLib_Encrypt.Hpp
//
// DESCRIPTION:
//
//  This module implements the abstract base class TEncrypter, which is
//  used by the system to do all encryption. This allows many different
//  encryption systems to be substituted into the system.
//
//  All the concrete derivatives of this class are in the CIDCrypto.Dll
//  facility.
//
// AUTHOR: Dean Roddey
//
// CREATE TDate: 12/02/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TEncrypter
//  PREFIX: cryp
// ----------------------------------------------------------------------------
class CIDLIBEXP TEncrypter : public TObject
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructor
        // --------------------------------------------------------------------
        ~TEncrypter();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TCard4 c4BlockSize() const;

        tCIDLib::TCard4 c4Decrypt
        (
            const   TMemBuf&                mbufCypher
            ,       TMemBuf&                mbufPlain
            , const tCIDLib::TCard4         c4CypherBytes = 0
        );

        tCIDLib::TCard4 c4Decrypt
        (
            const   TMemBuf&                mbufCypher
            ,       TString&                strPlain
            , const tCIDLib::TCard4         c4CypherBytes = 0
        );

        tCIDLib::TCard4 c4Encrypt
        (
            const   TMemBuf&                mbufPlain
            ,       TMemBuf&                mbufCypher
            , const tCIDLib::TCard4         c4PlainBytes = 0
        );

        tCIDLib::TCard4 c4Encrypt
        (
            const   TString&                strPlain
            ,       TMemBuf&                mbufCypher
        );


    protected   :
        // --------------------------------------------------------------------
        //  Hidden constructors and operators
        // --------------------------------------------------------------------
        TEncrypter
        (
            const   tCIDLib::TCard4         c4BlockSize = 1
        );


        // --------------------------------------------------------------------
        //  Protected, virtual methods
        // --------------------------------------------------------------------
        virtual tCIDLib::TCard4 _c4Decrypt
        (
            const   tCIDLib::TCard1* const  pc1Cypher
            , const tCIDLib::TCard4         c4CypherBytes
            ,       tCIDLib::TCard1* const  pc1PlainBuf
            , const tCIDLib::TCard4         c4BufSize
        ) = 0;

        virtual tCIDLib::TCard4 _c4Encrypt
        (
            const   tCIDLib::TCard1* const  pc1Plain
            , const tCIDLib::TCard4         c4PlainBytes
            ,       tCIDLib::TCard1* const  pc1CypherBuf
            , const tCIDLib::TCard4         c4BufSize
        ) = 0;


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TEncrypter(const TEncrypter&);

        tCIDLib::TVoid operator=(const TEncrypter&);


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __c4BlockSize
        //      The block size used by the derived class. It is passed to the
        //      protected constructor by the derived class and we just store
        //      it and provide access to it.
        // --------------------------------------------------------------------
        tCIDLib::TCard4     __c4BlockSize;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TEncrypter,TObject)
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  TEncrypter: Constructors and destructor
// ----------------------------------------------------------------------------
inline TEncrypter::TEncrypter(const tCIDLib::TCard4 c4BlockSize) :

    __c4BlockSize(c4BlockSize)
{
}

inline TEncrypter::~TEncrypter()
{
}


// ----------------------------------------------------------------------------
//  TEncrypter: Constructors and destructor
// ----------------------------------------------------------------------------
inline tCIDLib::TCard4 TEncrypter::c4BlockSize() const
{
    return __c4BlockSize;
}
