//
// NAME: CIDLib_Duplicable.Hpp
//
// DESCRIPTION:
//
//  This is the header for the CIDLib_Duplicable.Cpp module. This module
//  defines the simple polymorphic duplicability mixin class.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 01/06/92
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


// -----------------------------------------------------------------------------
//  Forward references
// -----------------------------------------------------------------------------
class   TClass;


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//  CLASS: MDuplicable
// PREFIX: dup
// -----------------------------------------------------------------------------
class CIDLIBEXP MDuplicable
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors
        // ---------------------------------------------------------------------
        MDuplicable();

        ~MDuplicable();


        // ---------------------------------------------------------------------
        //  Static methods
        // ---------------------------------------------------------------------
        static tCIDLib::TVoid TestCanDupTo
        (
            const   MDuplicable&            dupToCast
            , const TClass&                 clsToCastTo
        );

        static tCIDLib::TVoid TestCanDupTo
        (
            const   MDuplicable&            dupToCast
            , const tCIDLib::Tch* const     pszTypeName
        );


        // ---------------------------------------------------------------------
        //  Public, virtual methods
        // ---------------------------------------------------------------------
        virtual tCIDLib::TBoolean bIsDescendantOf
        (
            const   TClass&                 clsTarget
        )   const = 0;

        virtual const TClass& clsIsA() const = 0;

        virtual const TClass& clsParent() const = 0;

        virtual TObject* pobjDuplicate() const = 0;


    private :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        MDuplicable(const MDuplicable&);

        tCIDLib::TVoid operator=(const MDuplicable&);
};

#pragma pack(pop)



// -----------------------------------------------------------------------------
//  Constructors and destructors
// -----------------------------------------------------------------------------
inline MDuplicable::MDuplicable()
{
}

inline MDuplicable::~MDuplicable()
{
}


// -----------------------------------------------------------------------------
//  Inline for duplication
// -----------------------------------------------------------------------------
template <class T> T* pDupObject(const MDuplicable& dupToDup)
{
    // Optimize because this is a quick hashed compare
    MDuplicable::TestCanDupTo(dupToDup, T::clsThis);
    return (T*)dupToDup.pobjDuplicate();
}


// -----------------------------------------------------------------------------
//  This macro will provide the implemention of pobjDuplicate() that almost
//  every class will implement.
// -----------------------------------------------------------------------------
#define DefPolyDup(type) \
public : \
TObject* pobjDuplicate() const \
{ \
    return new type(*this); \
}
