//
// NAME: CIDLib_Duplicable.Cpp
//
// DESCRIPTION:
//
//  This module just implements a couple statics of the duplicable class.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 01/06/92
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


// ----------------------------------------------------------------------------
//  Facility specific includes
// ----------------------------------------------------------------------------
#include    "CIDLib_.Hpp"


// ----------------------------------------------------------------------------
//   CLASS: MDuplicable
//  PREFIX: dup
// ----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
//  MDuplicable: Public, static methods
// -----------------------------------------------------------------------------

tCIDLib::TVoid
MDuplicable::TestCanDupTo(  const   MDuplicable&    dupToCast
                            , const TClass&         clsToCastTo)
{
    if (!dupToCast.bIsDescendantOf(clsToCastTo))
    {
        facCIDLib.LogErr
        (
            __FILE__
            , __LINE__
            , kCIDErrs::errcRTTI_BadCast
            , tCIDLib::ESev_APIFailed
            , tCIDLib::EClass_CantDo
            , dupToCast.clsIsA()
            , clsToCastTo
        );
    }
}

tCIDLib::TVoid
MDuplicable::TestCanDupTo(  const   MDuplicable&        dupToCast
                            , const tCIDLib::Tch* const pszClassName)
{
    // Find the class object for this name first
    TClass clsToCastTo = TClass::clsForType(pszClassName);

    if (!dupToCast.bIsDescendantOf(clsToCastTo))
    {
        facCIDLib.LogErr
        (
            __FILE__
            , __LINE__
            , kCIDErrs::errcRTTI_BadCast
            , tCIDLib::ESev_APIFailed
            , tCIDLib::EClass_CantDo
            , dupToCast.clsIsA()
            , clsToCastTo
        );
    }
}
