//
// NAME: CIDLib_DirIter.Hpp
//
// DESCRIPTION:
//
//  TDirIter is a directory iterator. It is basically a wrapper around the
//  host findfirst/findnext APIs. Each new TDirIter object is a single threaded
//  search mechanism, i.e. each thread (or successive levels of recursion)
//  should create a new one. These objects cannot be copied or assigned. This
//  class is implmented in terms of the kernel class, TKrnlDirSearch, which
//  provides access to host file search services.
//
//
// AUTHOR: Dean Roddey
//
// CREATE TDate: 06/12/93
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//



#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TDirIter
//  PREFIX: diter
// ----------------------------------------------------------------------------
class CIDLIBEXP TDirIter : public TObject
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        TDirIter();

        ~TDirIter();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TBoolean bFindNext
        (
                    TFindBuf&               fndbToFill
        );

        tCIDLib::TBoolean bFindFirst
        (
            const   TString&                strSpec
            ,       TFindBuf&               fndbToFill
            , const tCIDLib::EFileAttrs     eCanBe = tCIDLib::EFileAttr_All
            , const tCIDLib::EFileAttrs     eMustBe = tCIDLib::EFileAttr_None
        );

        tCIDLib::TBoolean bFindFirst
        (
            const   TString&                strPath
            , const TString&                strWildCard
            ,       TFindBuf&               fndbToFill
            , const tCIDLib::EFileAttrs     eCanBe = tCIDLib::EFileAttr_All
            , const tCIDLib::EFileAttrs     eMustBe = tCIDLib::EFileAttr_None
        );

        tCIDLib::TVoid Reset();


    private             :
        // --------------------------------------------------------------------
        //  Unimplemented constructors/operators
        // --------------------------------------------------------------------
        TDirIter(const TDirIter&);

        tCIDLib::TVoid operator=(const TDirIter&);


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __kdsSearch
        //      This is the kernel search object for this search.
        //
        //  __pathSearchSpec
        //      This is the passed search spec. It is saved for logging errors
        //      and so it can be prepended to the file name.
        // --------------------------------------------------------------------
        TKrnlDirSearch          __kdsSearch;
        TPathStr                __pathSearchSpec;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TDirIter,TObject)
};

#pragma pack(pop)
