//
// NAME: CIDLib_CriticalSection.Hpp
//
// DESCRIPTION:
//
//  This header defines and implements a critical section class. This class
//  is implmented in terms of the kernel class, TKrnlCritSec. This guy
//  throws no exceptions, so its safe to use in the most primal places.
//
//  Also implemented here is a simple critical section janitor that makes
//  it safe to use critical sections in an exception based world.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 05/23/93
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//
//  1)  We don't have a Cpp file so our out of line stuff is in CIDLib.Cpp
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TCriticalSection
//  PREFIX: crs
// ----------------------------------------------------------------------------
class CIDLIBEXP TCriticalSection : public TObject, public TKrnlCritSec
{
    public  :
        // --------------------------------------------------------------------
        //  Constuctors and Destructors
        // --------------------------------------------------------------------
        TCriticalSection() {}

        ~TCriticalSection() {}


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TCriticalSection(const TCriticalSection&);

        tCIDLib::TVoid operator=(const TCriticalSection&);


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TCriticalSection,TObject)
};


// ----------------------------------------------------------------------------
//   CLASS: TCritSecLock
//  PREFIX: crsl
// ----------------------------------------------------------------------------
class CIDLIBEXP TCritSecLock : public  TObject
{
    public  :
        // --------------------------------------------------------------------
        //  Constuctors and Destructors
        // --------------------------------------------------------------------
        TCritSecLock
        (
                    TCriticalSection* const pcrsToSanitize
        );

        ~TCritSecLock();

    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TCritSecLock(const TCritSecLock&);

        tCIDLib::TVoid operator=(const TCritSecLock&);


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __pcrsSanitize
        //      This is the critical section to sanitize.
        // --------------------------------------------------------------------
        TCriticalSection*   __pcrsSanitize;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TCritSecLock,TObject)
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  TCritSecLock: Constructors and Destructors
// ----------------------------------------------------------------------------
inline TCritSecLock::TCritSecLock(TCriticalSection* const pcrsToSanitize) :

    __pcrsSanitize(0)
{
    // Try to enter
    pcrsToSanitize->Enter();

    // We made it so store the pointer
    __pcrsSanitize = pcrsToSanitize;

}

inline TCritSecLock::~TCritSecLock()
{
    // If we locked it, then unlock it
    if (__pcrsSanitize)
        __pcrsSanitize->Exit();
}
