//
// NAME: CIDLib_Console.Hpp
//
// DESCRIPTION: 
//
//  This is a specialized stream for interactive console input/output. It can
//  do some much fancier stuff than just getting TTY input line by line via a
//  text stream. This guy provides command line editing and recall, so
//  effectively its a command line processor. This class is implemented in terms
//  of the kernel class, TKrnlConsole, which provides access to system console
//  services.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 09/22/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//

#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TConsoleImpl
//  PREFIX: strmi
// ----------------------------------------------------------------------------
class CIDLIBEXP TConsoleImpl : public TTextStreamImpl
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        TConsoleImpl();

        TConsoleImpl
        (
            const   tCIDLib::TBoolean       bInsertMode
            , const tCIDLib::TCard4         c4MaxRecall
            , const tCIDLib::ERedir         eRedirect = tCIDLib::ERedir_Allow
        );

        TConsoleImpl
        (
            const   tCIDLib::TBoolean       bInsertMode
            , const tCIDLib::TCard4         c4MaxRecall
            , const tCIDLib::ETextFormats   eTextFmt
            , const tCIDLib::ERedir         eRedirect = tCIDLib::ERedir_Allow
        );

        ~TConsoleImpl();


        // --------------------------------------------------------------------
        //  Public, inherited methods
        // --------------------------------------------------------------------
        tCIDLib::TBoolean bEndOfStream() const;

        tCIDLib::TCard4 c4GetLine
        (
                    tCIDLib::Tch* const     pszBufToFill
            , const tCIDLib::TCard4         c4MaxChars
            , const tCIDLib::TBoolean       bStripWhitespace = kCIDLib::True
        );

        tCIDLib::Tch chGet();

        tCIDLib::TFilePos fposCurPos() const;

        tCIDLib::TFilePos fposLogicalEnd() const;

        tCIDLib::TFilePos fposPhysicalEnd() const;

        tCIDLib::TFilePos fposSeekToEnd();

        tCIDLib::TFilePos fposSkipForwardBy
        (
            const   tCIDLib::TCard4         c4SkipBy
        );

        tCIDLib::TVoid PutCh
        (
            const   tCIDLib::Tch            chToWrite
        );

        tCIDLib::TVoid PutCh
        (
            const   tCIDLib::Tsch           schToWrite
        );

        tCIDLib::TVoid PutLine
        (
            const   tCIDLib::Tch* const     pszBufToWrite
        );

        tCIDLib::TVoid PutLine
        (
            const   tCIDLib::Tsch* const    pszBufToWrite
        );

        tCIDLib::TVoid Reset();

        tCIDLib::Tsch schGet();

        tCIDLib::TVoid TruncateAtZero();


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TConsoleImpl(const TConsoleImpl&);

        tCIDLib::TVoid operator=(const TConsoleImpl&);


    private :
        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __kconImpl
        //      This is the kernel console object that provides the real
        //      implementation. We just pass input/output calls to it.
        // --------------------------------------------------------------------
        TKrnlConsole    __kconImpl;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TConsoleImpl,TTextStreamImpl)
};



// ----------------------------------------------------------------------------
//   CLASS: TConsole
//  PREFIX: cons
// ----------------------------------------------------------------------------
class CIDLIBEXP TConsole : public TTextStream
{
    public  :
        // --------------------------------------------------------------------
        //  Constuctors and Destructors
        // --------------------------------------------------------------------
        TConsole();

        TConsole
        (
            const   tCIDLib::TBoolean       bInsertMode
            , const tCIDLib::TCard4         c4RecallBufSize
            , const tCIDLib::ERedir         eRedirect = tCIDLib::ERedir_Allow
        );

        TConsole
        (
            const   tCIDLib::TBoolean       bInsertMode
            , const tCIDLib::TCard4         c4RecallBufSize
            , const tCIDLib::ETextFormats   eTextFmt
            , const tCIDLib::ERedir         eRedirect = tCIDLib::ERedir_Allow
        );

        ~TConsole();


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TConsole(const TConsole&);

        tCIDLib::TVoid operator=(const TConsole&);


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TConsole,TTextStream)
};

#pragma pack(pop)
