//
// NAME: CIDLib_ColorPalette.Hpp
//
// DESCRIPTION:
//
//  This is the header for the CIDLib_Palette.Cpp module. This module
//  provides the TClrPalette class. Palettes can have up to 8192 colors and
//  support a number of convenient palette operations such as rotations,
//  inversion, global color adjustment, etc... Palettes are storable and
//  duplicable so they mixin the MStreamable and MDuplicable interfaces.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 09/24/93
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


// -----------------------------------------------------------------------------
//  Forward references 
// -----------------------------------------------------------------------------
class   TStreamParser;
class   TElemCursor<TRGBClr>;


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//   CLASS: TClrPalette
//  PREFIX: pal
// -----------------------------------------------------------------------------
class CIDLIBEXP TClrPalette :

    public TObject, public MStreamable, public MDuplicable
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors
        // ---------------------------------------------------------------------
        TClrPalette();

        TClrPalette
        (
            const   tCIDLib::EDefPalettes   ePalette
        );

        TClrPalette
        (
            const   tCIDLib::TCard4         c4ClrCount
        );

        TClrPalette
        (
            const   tCIDLib::TCard4         c4ClrCnt
            ,       TElemCursor<TRGBClr>&   cursInitList
        );

        TClrPalette
        (
            const   TClrPalette&            palToCopy
        );

        ~TClrPalette();


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        TClrPalette& operator=
        (
            const   TClrPalette&            palAssign
        );

        tCIDLib::TBoolean operator==
        (
            const   TClrPalette&            palToTest
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   TClrPalette&            palToTest
        )   const;

        const TRGBClr& operator[]
        (
            const   tCIDLib::TCard4         c4Index
        )   const;

        TRGBClr& operator[]
        (
            const   tCIDLib::TCard4         c4Index
        );


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TCard4  c4ClrCount() const;

        tCIDLib::TCard4 c4ParseFromText
        (
            const   TString&                strFile
            , const tCIDLib::EPalTxtFormats eFormat = tCIDLib::EPalFmt_SpaceDelimited
            , const tCIDLib::ETextFormats   eTextFmt = tCIDLib::ETextFmt_UNICode
        );

        tCIDLib::TCard4 c4ParseFromText
        (
                    TStreamParser&          prsrSrc
            , const tCIDLib::EPalTxtFormats eFormat = tCIDLib::EPalFmt_SpaceDelimited
        );

        const TRGBClr& rgbAt
        (
            const   tCIDLib::TCard4         c4Index
        )   const;

        TRGBClr& rgbAt
        (
            const   tCIDLib::TCard4         c4Index
        );

        tCIDLib::TVoid RotateBackward
        (
            const   tCIDLib::TCard4         c4Count = 1
        );

        tCIDLib::TVoid RotateForward
        (
            const   tCIDLib::TCard4         c4Count = 1
        );


    protected   :
        // ---------------------------------------------------------------------
        //  Protected, inherited methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&             strmToFormat
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&             strmToFormat
        )   const;


    private :
        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  NOTE:   __c4ClrCount MUST be first when stored, for persistence
        //          reasons. It is required so that the count can be read
        //          first and then enough space allocated.
        //
        //  __c4ClrCount
        //      This is the number of colors in the palette. It is set at
        //      construction time and never changed.
        //
        //  __pargbClrs
        //      This is a pointer to the array of colors allocated by the
        //      constructor.
        // ---------------------------------------------------------------------
        tCIDLib::TCard4         __c4ClrCount;
        TRGBClr*                __pargbClrs;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TClrPalette,TObject)
        DefPolyDup(TClrPalette)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  Public operators
// -----------------------------------------------------------------------------
inline tCIDLib::TBoolean
TClrPalette::operator!=(const TClrPalette& palToTest) const
{
    return !operator==(palToTest);
}

inline const TRGBClr&
TClrPalette::operator[](const tCIDLib::TCard4 c4Index) const
{
    return rgbAt(c4Index);
}

inline TRGBClr& TClrPalette::operator[](const tCIDLib::TCard4 c4Index)
{
    return rgbAt(c4Index);
}

// -----------------------------------------------------------------------------
//  Public, non-virtual methods
// -----------------------------------------------------------------------------
inline tCIDLib::TCard4 TClrPalette::c4ClrCount() const
{
    return __c4ClrCount;
}
