//
// NAME: CIDLib_Cardinal.Hpp
//
// DESCRIPTION:
//
//  This is the header for the CIDLib_Cardinal.Cpp module. This module
//  implements a class wrapper (TCardinal) for a 32 bit unsigned integer. Its
//  a very simple class and makes no attempt to create a fully mathematical
//  functional class. Its purely for formatting purposes and for when a
//  cardinal value needs to act like an object.
//
//  A simple derivative, TLocCardinal, is provided also. This one just
//  overrides the text formatting stuff and formats according to locale
//  rules with grouping and separators and sign and all of that.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 04/15/93
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


// ----------------------------------------------------------------------------
//  Forward references
// ----------------------------------------------------------------------------
class   TFloat;
class   TInteger;


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//  CLASS: TCardinal
// PREFIX: c
// ----------------------------------------------------------------------------
class CIDLIBEXP TCardinal :

    public TObject, public MFormattable, public MDuplicable, public MStreamable
{
    public  :
        // --------------------------------------------------------------------
        // Constructors and Destructors
        // --------------------------------------------------------------------
        TCardinal();

        TCardinal
        (
            const   tCIDLib::TCard4         c4Val
            , const tCIDLib::ERadices       eRadix = tCIDLib::ERadix_Dec
        );

        TCardinal
        (
            const   TCardinal&              cToCopy
        );

        ~TCardinal();


        // --------------------------------------------------------------------
        //  Public operators
        // --------------------------------------------------------------------
        operator tCIDLib::TCard4() const;

        TCardinal& operator=
        (
                    tCIDLib::TCard4         c4ToAssign
        );

        TCardinal& operator=
        (
            const   TCardinal&              cToAssign
        );

        tCIDLib::TBoolean operator==
        (
            const   TCardinal&              cToTest
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   TCardinal&              cToTest
        )   const;

        tCIDLib::TBoolean operator==
        (
            const   tCIDLib::TCard4         c4ToTest
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   tCIDLib::TCard4         c4ToTest
        )   const;

        tCIDLib::TBoolean operator<
        (
            const   TCardinal&              cComp
        )   const;

        tCIDLib::TBoolean operator<=
        (
            const   TCardinal&              cComp
        )   const;

        tCIDLib::TBoolean operator>
        (
            const   TCardinal&              cComp
        )   const;

        tCIDLib::TBoolean operator>=
        (
            const   TCardinal&              cComp
        )   const;


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TCard4 c4Val() const;

        tCIDLib::TCard4 c4Val
        (
            const   tCIDLib::TCard4         c4NewVal
        );

        tCIDLib::ERadices eRadix() const;

        tCIDLib::ERadices eRadix
        (
            const   tCIDLib::ERadices       eNewRadix
        );


    protected   :
        // --------------------------------------------------------------------
        //  Protected, inherited methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmDest
        )   const;

        tCIDLib::TVoid _StreamFrom
        (
                    TBinaryStream&             strmToReadFrom
        );

        tCIDLib::TVoid _StreamTo
        (
                    TBinaryStream&             strmToWriteTo
        )   const;


    private             :
        // --------------------------------------------------------------------
        //  Public data members
        //
        //  __c4Val
        //      Storage for the data value.
        //
        //  __eRadix
        //      This is the display radix
        // --------------------------------------------------------------------
        tCIDLib::TCard4         __c4Val;
        tCIDLib::ERadices       __eRadix;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TCardinal,TObject)
        DefPolyDup(TCardinal)
};



// ----------------------------------------------------------------------------
//  CLASS: TLocCardinal
// PREFIX: c
// ----------------------------------------------------------------------------
class CIDLIBEXP TLocCardinal : public TCardinal
{
    public  :
        // --------------------------------------------------------------------
        // Constructors and Destructors
        // --------------------------------------------------------------------
        TLocCardinal();

        TLocCardinal
        (
            const   tCIDLib::TCard4         c4Val
        );

        TLocCardinal
        (
            const   TLocCardinal&           cToCopy
        );

        ~TLocCardinal();


        // --------------------------------------------------------------------
        //  Public operators
        // --------------------------------------------------------------------
        TLocCardinal& operator=
        (
            const   TLocCardinal&           cToAssign
        );

        tCIDLib::TBoolean operator==
        (
            const   TLocCardinal&           cToTest
        )   const;

        tCIDLib::TBoolean operator!=
        (
            const   TLocCardinal&           cToTest
        )   const;

        tCIDLib::TBoolean operator<
        (
            const   TLocCardinal&           cToCompare
        )   const;

        tCIDLib::TBoolean operator<=
        (
            const   TLocCardinal&           cToCompare
        )   const;

        tCIDLib::TBoolean operator>
        (
            const   TLocCardinal&           cToCompare
        )   const;

        tCIDLib::TBoolean operator>=
        (
            const   TLocCardinal&           cToCompare
        )   const;


    protected   :
        // --------------------------------------------------------------------
        //  Protected, inherited methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid _FormatTo
        (
                    TTextStream&            strmDest
        )   const;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TLocCardinal,TCardinal)
        DefPolyDup(TLocCardinal)
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  TCardinal: Constructors and destrutors
// ----------------------------------------------------------------------------
inline TCardinal::~TCardinal()
{
}

// ----------------------------------------------------------------------------
//  Public operators
// ----------------------------------------------------------------------------
inline TCardinal::operator tCIDLib::TCard4() const
{
    return __c4Val;
}

inline TCardinal& TCardinal::operator=(tCIDLib::TCard4 c4ToAssign)
{
    __c4Val = c4ToAssign;
    return *this;
}

inline tCIDLib::TBoolean TCardinal::operator!=(const TCardinal& cToTest) const
{
    return !operator==(cToTest);
}

inline tCIDLib::TBoolean TCardinal::operator==(const tCIDLib::TCard4 c4ToTest) const
{
    return (c4ToTest == __c4Val);
}

inline tCIDLib::TBoolean TCardinal::operator!=(const tCIDLib::TCard4 c4ToTest) const
{
    return (c4ToTest != __c4Val);
}

inline tCIDLib::TBoolean TCardinal::operator<(const TCardinal& cComp) const
{
    return (__c4Val < cComp.__c4Val);
}

inline tCIDLib::TBoolean TCardinal::operator<=(const TCardinal& cComp) const
{
    return (__c4Val <= cComp.__c4Val);
}

inline tCIDLib::TBoolean TCardinal::operator>(const TCardinal& cComp) const
{
    return (__c4Val > cComp.__c4Val);
}

inline tCIDLib::TBoolean TCardinal::operator>=(const TCardinal& cComp) const
{
    return (__c4Val >= cComp.__c4Val);
}


// ----------------------------------------------------------------------------
//  TCardinal: Public, non-virtual methods
// ----------------------------------------------------------------------------
inline tCIDLib::TCard4 TCardinal::c4Val() const
{
    return __c4Val;
}

inline tCIDLib::TCard4 TCardinal::c4Val(const tCIDLib::TCard4 c4NewVal)
{
    __c4Val = c4NewVal;
    return __c4Val;
}

inline tCIDLib::ERadices TCardinal::eRadix() const
{
    return __eRadix;
}

inline tCIDLib::ERadices TCardinal::eRadix(const tCIDLib::ERadices eNewRadix)
{
    __eRadix = eNewRadix;
    return __eRadix;
}


// ----------------------------------------------------------------------------
//  TLocCardinal: Constructor and destructors
// ----------------------------------------------------------------------------
inline TLocCardinal::TLocCardinal()
{
}

inline TLocCardinal::TLocCardinal(const tCIDLib::TCard4 c4Val) :

    TCardinal(c4Val, tCIDLib::ERadix_Dec)
{
}

inline TLocCardinal::TLocCardinal(const TLocCardinal& cToCopy) :

    TCardinal(cToCopy)
{
}

inline TLocCardinal::~TLocCardinal()
{
}

// ----------------------------------------------------------------------------
//  TLocCardinal: Public operators
// ----------------------------------------------------------------------------
inline TLocCardinal& TLocCardinal::operator=(const TLocCardinal& cToAssign)
{
    TParent::operator=(cToAssign);
    return *this;
}

inline tCIDLib::TBoolean
TLocCardinal::operator==(const TLocCardinal& cToTest) const
{
    return TParent::operator==(cToTest);
}

inline tCIDLib::TBoolean
TLocCardinal::operator!=(const TLocCardinal& cToTest) const
{
    return !TParent::operator==(cToTest);
}

inline tCIDLib::TBoolean TLocCardinal::operator<(const TLocCardinal& cComp) const
{
    return TParent::operator<(cComp);
}

inline tCIDLib::TBoolean TLocCardinal::operator<=(const TLocCardinal& cComp) const
{
    return TParent::operator<=(cComp);
}

inline tCIDLib::TBoolean TLocCardinal::operator>(const TLocCardinal& cComp) const
{
    return TParent::operator>(cComp);
}

inline tCIDLib::TBoolean TLocCardinal::operator>=(const TLocCardinal& cComp) const
{
    return TParent::operator>=(cComp);
}
