//
// NAME: CIDLib_BinaryMBufStream.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the CIDLib_BinaryMBufStream.Cpp module. This
//  module provides a very simple derivative of TBinaryStream. It just
//  handles the management of the stream implementation object, which in
//  this case manages a memory buffer object. This stuff can all be done
//  manually, but this class just makes it safer.
//
//  Since these tend to be large, so it uses a system memory buffer which
//  can be committed over time without having to allocate another buffer
//  and copying the old contents in when the buffer needs to be expanded.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 08/01/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TBinaryMBufStream
//  PREFIX: strm
// ----------------------------------------------------------------------------
class CIDLIBEXP TBinaryMBufStream : public TBinaryStream
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and destructors
        // --------------------------------------------------------------------
        TBinaryMBufStream
        (
            const   tCIDLib::TCard4         c4InitSize
            , const tCIDLib::TCard4         c4MaxSize = kCIDLib::c4MaxCard
            , const tCIDLib::EMemAccFlags   eAccFlags = tCIDLib::EMemAcc_ReadWrite
        );

        ~TBinaryMBufStream();


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TBinaryMBufStream();

        TBinaryMBufStream(const TBinaryMBufStream&);

        tCIDLib::TVoid operator=(const TBinaryMBufStream&);


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TBinaryMBufStream,TBinaryStream)
};

#pragma pack(pop)
