//
// NAME: CIDLib_BinaryMBufStream.Cpp
//
// DESCRIPTION: 
//
//  This module implements a simple derivative of the binary stream class.
//  This one handles the issues of creating the stream implementation
//  object and getting the file created and opened. You can do this yourself
//  and use a TBinaryStream, but this one is safer.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 08/01/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// ----------------------------------------------------------------------------
//  Facility specific includes
// ----------------------------------------------------------------------------
#include    "CIDLib_.Hpp"


// ----------------------------------------------------------------------------
//  Do our standard members macros
// ----------------------------------------------------------------------------
RTTIData(TBinaryMBufStream,TBinaryStream)


// ----------------------------------------------------------------------------
//  TBinaryMBufStream: Constructors and destructors
// ----------------------------------------------------------------------------

TBinaryMBufStream::TBinaryMBufStream(const   tCIDLib::TCard4        c4InitSize
                                     , const tCIDLib::TCard4        c4MaxSize
                                     , const tCIDLib::EMemAccFlags  eAccFlags)
{
    // Create the system buffer that 
    TSysBuf* pmbufData = 0;
    TMemBinStreamImpl* pstrmiBuf = 0;
    try
    {
        pmbufData = new TSysBuf(c4InitSize, c4MaxSize, eAccFlags);

        // Tell the implementation object to adopt the 
        pstrmiBuf = new TMemBinStreamImpl(pmbufData, tCIDLib::EAdoptOpt_Adopt);
    }

    catch(...)
    {
        //
        //  Delete anything we got created. If stream implementation got
        //  created, then it owns the memory buffer so only delete it manually
        //  if the stream implementation failed.
        //
        if (!pstrmiBuf)
            delete pmbufData;
        delete pstrmiBuf;
        throw;
    }

    // Pass on the new stream implementation object to our base class
    _AdoptImplObject(pstrmiBuf);
}

TBinaryMBufStream::~TBinaryMBufStream()
{
}
