//
// NAME: CIDLib_BinaryFileStream.Hpp
//
// DESCRIPTION: 
//
//  This is the header for the CIDLib_BinaryFileStream.Cpp module. This
//  module provides a very simple derivative of TBinaryStream. It just
//  handles the management of the stream implementation object, which in
//  this case manages a binary file object. This stuff can all be done
//  manually, but this class just makes it safer.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 09/28/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TBinaryFileStream
//  PREFIX: strm
// ----------------------------------------------------------------------------
class CIDLIBEXP TBinaryFileStream : public TBinaryStream
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and destructors
        // --------------------------------------------------------------------
        TBinaryFileStream();

        TBinaryFileStream
        (
            const   TString&                strFileName
            , const tCIDLib::EAccessModes   eAccess
            , const tCIDLib::ECreateActions eAction
            , const tCIDLib::EFileAttrs     eAttrs
            , const tCIDLib::EFileFlags     eFlags
        );

        ~TBinaryFileStream();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid Close();

        tCIDLib::TVoid Open
        (
            const   TString&                strFileName
            , const tCIDLib::EAccessModes   eAccess
            , const tCIDLib::ECreateActions eAction
            , const tCIDLib::EFileAttrs     eAttrs
            , const tCIDLib::EFileFlags     eFlags
        );


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TBinaryFileStream(const TBinaryFileStream&);

        tCIDLib::TVoid operator=(const TBinaryFileStream&);


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TBinaryFileStream,TBinaryStream)
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  Public, non-virtual methods
// ----------------------------------------------------------------------------
inline tCIDLib::TVoid TBinaryFileStream::Close()
{
    //
    //  We know that the implementation object is a file stream impl
    //  because we created it and there is no interface to replace it.
    //
    ((TFileBinStreamImpl&)_strmiThis()).Close();
}
