//
// NAME: CIDLib_BinaryFileStream.Cpp
//
// DESCRIPTION: 
//
//  This module implements a simple derivative of the binary stream class.
//  This one handles the issues of creating the stream implementation
//  object and getting the file created and opened. You can do this yourself
//  and use a TBinaryStream, but this one is safer.
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 09/26/96
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// ----------------------------------------------------------------------------
//  Facility specific includes
// ----------------------------------------------------------------------------
#include    "CIDLib_.Hpp"


// ----------------------------------------------------------------------------
//  Do our standard members macros
// ----------------------------------------------------------------------------
RTTIData(TBinaryFileStream,TBinaryStream)


// ----------------------------------------------------------------------------
//  TBinaryFileStream: Constructors and destructors
// ----------------------------------------------------------------------------

TBinaryFileStream::TBinaryFileStream()
{
}

TBinaryFileStream::TBinaryFileStream(   const   TString&                strFileName
                                        , const tCIDLib::EAccessModes   eAccess
                                        , const tCIDLib::ECreateActions eAction
                                        , const tCIDLib::EFileAttrs     eAttrs
                                        , const tCIDLib::EFileFlags     eFlags)
{
    Open(strFileName, eAccess, eAction, eAttrs, eFlags);
}

TBinaryFileStream::~TBinaryFileStream()
{
}

tCIDLib::TVoid
TBinaryFileStream::Open(const   TString&                strFileName
                        , const tCIDLib::EAccessModes   eAccess
                        , const tCIDLib::ECreateActions eAction
                        , const tCIDLib::EFileAttrs     eAttrs
                        , const tCIDLib::EFileFlags     eFlags)
{
    // Init these guys so we can clean up in case of error
    TBinaryFile*        pflToUse    = 0;
    TFileBinStreamImpl* pstrmiToUse = 0;

    try
    {
        // Construct the binary file object
        pflToUse = new TBinaryFile(strFileName);

        // Try to open/create it with the provided information
        pflToUse->Open(eAccess, eAction, eAttrs, eFlags);

        //
        //  Ok, create the file stream implementation object and give it
        //  the file we just created and tell it to adopt it.
        //
        pstrmiToUse = new TFileBinStreamImpl(pflToUse, tCIDLib::EAdoptOpt_Adopt);
    }

    catch(...)
    {
        if (pstrmiToUse)
        {
            delete pstrmiToUse;
            pstrmiToUse = 0;
        }
         else
        {
            delete pflToUse;
            pflToUse = 0;
        }
        throw;
    }

    // Pass on the new stream implementation object to our base class
    _AdoptImplObject(pstrmiToUse);
}
