//
// NAME: CIDLib_BinFile.Hpp
//
// DESCRIPTION:
//
//  This module implements the TBinaryFile class, which supports random
//  access, binary file support. It is based on the fundamental file class,
//  TFileBase. TFileBase provides the open/close calls, as well as the
//  generic buffer read and buffer write methods that are the basis of all
//  file I/O done by this class. It also provides other protected interfaces
//  that specific derivatives can make public via passthrough methods. We
//  do this for the read, write, and seek methods.
//
//
// AUTHOR: Dean Roddey
//
// CREATE TDate: 06/28/93
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//   CLASS: TBinaryFile
//  PREFIX: bfl
// -----------------------------------------------------------------------------
class CIDLIBEXP TBinaryFile : public TFileBase
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors
        // ---------------------------------------------------------------------
        TBinaryFile();

        TBinaryFile
        (
            const   TString&                strFileName
        );

        TBinaryFile
        (
            const   tCIDLib::Tch* const     pszFileName
        );

        ~TBinaryFile();


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        TBinaryStream* pstrmMakeNew
        (
            const   tCIDLib::EAdoptOpts     eAdopt = tCIDLib::EAdoptOpt_NoAdopt
        );

        tCIDLib::TVoid ReadBuf
        (
                    tCIDLib::TVoid* const   pBuf
            , const tCIDLib::TCard4         c4BufSz
            ,       tCIDLib::TCard4&        c4Actual  = NUL_TCard4
        );

        tCIDLib::TVoid Seek
        (
            const   tCIDLib::TFilePos       fposOffset
            , const tCIDLib::ESeekFrom      eSeekFrom = tCIDLib::ESeekFrom_Start
            ,       tCIDLib::TFilePos&      fposActual  = NUL_TFilePos
        );

        tCIDLib::TVoid WriteBuf
        (
            const   tCIDLib::TVoid* const   pBuf
            , const tCIDLib::TCard4         c4BufSz
            ,       tCIDLib::TCard4&        c4Actual = NUL_TCard4
        );


    private :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        TBinaryFile(const TBinaryFile&);

        tCIDLib::TVoid operator=(const TBinaryFile&);


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TBinaryFile,TFileBase)
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  Constructors and destructors
// -----------------------------------------------------------------------------
inline TBinaryFile::TBinaryFile()
{
}

inline TBinaryFile::TBinaryFile(const TString& strFileName) :

    TFileBase(strFileName)
{
}

inline TBinaryFile::TBinaryFile(const tCIDLib::Tch* const pszFileName) :

    TFileBase(pszFileName)
{
}

inline TBinaryFile::~TBinaryFile()
{
}

// -----------------------------------------------------------------------------
//  Public, non-virtual methods
// -----------------------------------------------------------------------------
inline tCIDLib::TVoid
TBinaryFile::ReadBuf(           tCIDLib::TVoid* const   pBuf
                        , const tCIDLib::TCard4         c4BufSz
                        ,       tCIDLib::TCard4&        c4Actual)
{
    _ReadBuf(pBuf, c4BufSz, c4Actual);
}

inline tCIDLib::TVoid
TBinaryFile::Seek(  const   tCIDLib::TFilePos   fposOffset
                    , const tCIDLib::ESeekFrom  eSeekFrom
                    ,       tCIDLib::TFilePos&  fposActual)
{
    _Seek(fposOffset, eSeekFrom, fposActual);
}

inline tCIDLib::TVoid
TBinaryFile::WriteBuf(  const   tCIDLib::TVoid* const   pBuf
                        , const tCIDLib::TCard4         c4BufSz
                        ,       tCIDLib::TCard4&        c4Actual)
{
    _WriteBuf(pBuf, c4BufSz, c4Actual);
}
