//
// NAME: CIDLib_BinFile.Cpp
//
// DESCRIPTION:
//
//  This module implements the TBinaryFile class. This class is a derivative
//  of the primeval TFileBase class that allows for random access and
//  arbitrary read/write sizes.
//
//
// AUTHOR: Dean Roddey
//
// CREATE TDate: 06/20/93
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//


// ----------------------------------------------------------------------------
//  Facility specific includes
// ----------------------------------------------------------------------------
#include    "CIDLib_.Hpp"


// ----------------------------------------------------------------------------
//  Do our standard RTTI macros
// ----------------------------------------------------------------------------
RTTIData(TBinaryFile,TFileBase)


// ----------------------------------------------------------------------------
//   CLASS: TBinaryFile
//  PREFIX: bfl
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  TBinaryFile: Public, non-virtual methods
// ----------------------------------------------------------------------------

TBinaryStream* TBinaryFile::pstrmMakeNew(const tCIDLib::EAdoptOpts eAdopt)
{
    //
    //  We just create a new file stream implementation object, and pass
    //  it a pointer to ourself, and tell it the adoption scheme that the
    //  caller wanted.
    //
    //  This implementation object is then given to a newly allocated
    //  binary stream object, which is returned to the caller.
    //
    return new TBinaryStream(new TFileBinStreamImpl(this, eAdopt));
}
