//
// NAME: CIDLib_BaseLock.Hpp
//
// DESCRIPTION:
//
//  This is the header for the CIDLib_BaseLock.Cpp module. This module
//  implements a very simple class, TBaseLock, that is used for ad hoc
//  synchronization purposes. For instance, if a class wants to lazily create
//  statics or file scope globals, it does not make any sense for them to
//  have their own synchronization object for that since they will only ever
//  do it once (if at all) during any one run. So this class provides a single,
//  primal lock that is always available.
//
//  Just create an object of this type and you will have locked this primal
//  lock. When this object destructs the lock will be released. So its an
//  incredibly simple class and only has a default constructor and a
//  destructor.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 06/25/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS:
//
//  1)  This is not to be used for general purpose synchronization because it
//      would become a bottleneck. Use it for one shot atomic operations such
//      as lazy creation of statics and such.
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TBaseLock
//  PREFIX: lock
// ----------------------------------------------------------------------------
class TBaseLock : public TObject
{
    public  :
        // --------------------------------------------------------------------
        //  Constuctors and Destructors
        // --------------------------------------------------------------------
        TBaseLock();

        ~TBaseLock();


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TBaseLock(const TBaseLock&);

        tCIDLib::TVoid operator=(const TBaseLock&);


        // --------------------------------------------------------------------
        //  Magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TBaseLock, TObject)
};

#pragma pack(pop)
