//
// NAME: CIDLib_BaseAudio.Hpp
//
// DESCRIPTION:
//
//  TAudio is a small class that does various beeps, bonks, zings, and
//  honks all of which are given enumerated values. The facCIDLib facility
//  provides one of these as a data member that the process can generate
//  sounds on. Higher level libraries will probably derive much more
//  powerful classes from TAudio and then install them to be used as
//  the program's audio output object.
//
//
// AUTHOR: Dean Roddey
//
// CREATE TDate: 11/08/93
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TAudio
//  PREFIX: audio
// ----------------------------------------------------------------------------
class CIDLIBEXP TAudio : public TObject, public MDuplicable
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        TAudio();

        TAudio
        (
            const   TAudio&                 audioToCopy
        );

        ~TAudio();


        // --------------------------------------------------------------------
        //  Public operators
        // --------------------------------------------------------------------
        TAudio& operator=(const TAudio& audioToCopy);


        // --------------------------------------------------------------------
        //  Public virtual methods
        // --------------------------------------------------------------------
        virtual tCIDLib::TVoid AudioCue
        (
            const   tCIDLib::EAudioCues     eCue
        )   const;

        virtual tCIDLib::TVoid Beep
        (
            const   tCIDLib::TCard4         c4Frequency
            , const tCIDLib::TCard4         c4Duration
        )   const;


        // --------------------------------------------------------------------
        //  Do any needed magic macros
        // --------------------------------------------------------------------
        RTTIMacros(TAudio,TObject)
        DefPolyDup(TAudio)
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  Constructors and destructors
// ----------------------------------------------------------------------------
inline TAudio::TAudio()
{
}

inline TAudio::TAudio(const TAudio& audioToCopy)
{
}

inline TAudio::~TAudio()
{
}


// ----------------------------------------------------------------------------
//  Public operators
// ----------------------------------------------------------------------------
inline TAudio& TAudio::operator=(const TAudio& audioToCopy)
{
    return *this;
}
