//
//  FILE NAME: CIDLib_.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/23/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the main internal header for the facility. It includes the main
//  public header, any internal headers that are needed, intrafacility function
//  prototypes, intrafacility constants, and macros.
//
//  CAVEATS/GOTCHAS:
//


// ----------------------------------------------------------------------------
//  Include our own public header and any internal headers we need
// ----------------------------------------------------------------------------
#include    "CIDLib.Hpp"


// ----------------------------------------------------------------------------
//  Include any intra-facility headers
// ----------------------------------------------------------------------------
#include    "CIDLib_MessageIds.Hpp"


// ----------------------------------------------------------------------------
//  This is the intra-facilities types namespace. It contains non-class types
//  for use within the facility.
// ----------------------------------------------------------------------------
namespace tCIDLib_
{
    // ------------------------------------------------------------------------
    //  These are the indexes for the CIDLib core metrics.
    //
    //  Verbose
    //      This is a toggle type metric that is set to the verbose state.
    //      This is handled by the facCIDLib.eVerboseMode() method which
    //      just stores the new state and then passes it on to the metric.
    //
    //  ThreadCnt
    //      The count of threads in existence in this process, but not
    //      necessarily running.
    //
    //  WarningMsgs
    //  FailureMsgs
    //  FatalMsgs
    //      The number of messages of various levels of severity have been
    //      logged.
    //
    //  ObjCount
    //      The count of TObject derived objects in existence in this
    //      process.
    //
    //  OpenFiles
    //      The number of file objects that are currently in an open state.
    // ------------------------------------------------------------------------
    enum eCoreMetrics
    {
        eCoreMetric_Verbose
        , eCoreMetric_ThreadCnt
        , eCoreMetric_WarningMsgs
        , eCoreMetric_FailureMsgs
        , eCoreMetric_FatalMsgs
        , eCoreMetric_ObjCount
        , eCoreMetric_OpenFiles

        // This one must be last!!!
        , eCoreMetric_Count
    };
};


// ----------------------------------------------------------------------------
//  This is the intra-facilities constants namespace.
// ----------------------------------------------------------------------------
namespace kCIDLib_
{
    //
    //  These are the strings used in any popups that are done. These are
    //  default values that will be left if the load of these strings from
    //  resources fails.
    //
    const tCIDLib::Tch* const pszTitle1 = L"CIDLib Core Layer";
    const tCIDLib::Tch* const pszTitle2 = L"Copyright (c) CIDLib 1992..1997";
};


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDLib.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _ReleaseMainThread
(
    const   tCIDLib::EExitCodes     eReturn
);


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDLib_Locale.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermLocale
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const TModule&                modInit
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDLib_Module.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermMod
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const TModule&                modInit
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDLib_Metrics.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermMetrics
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const TModule&                modInit
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);

extern TMetricGroup* _pmtrgCore;


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDLib_ProcessRegistry.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermProcessRegistry
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const TModule&                modInit
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDLib_TextStreams.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermTextStream
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const TModule&                modInit
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDLib_SystemInfo.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermSysInfo
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const TModule&                modInit
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDLib_Thread.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermThread
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const TModule&                modInit
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDLib_TypeRegistry.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermTypeRegistry
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const TModule&                modInit
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDLib_ThisFacility.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermThisFac
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const TModule&                modInit
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);


// ----------------------------------------------------------------------------
//  Intrafacility stuff from CIDLib_Type.Cpp
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid _InitTermThisType
(
    const   tCIDLib::EInitTerm      eInitTerm
    , const tCIDLib::EGlobalStates  eGlobals
    , const TModule&                modInit
    , const tCIDLib::TCard4         c4MaxChars
    ,       tCIDLib::Tch* const     pszFailReason
);



// ----------------------------------------------------------------------------
//  Macros to aid with error popups
// ----------------------------------------------------------------------------
#define _ERRPOPUP_(msg,err) \
TFacCIDLib::PopUpErr \
( \
    __FILE__ \
    , __LINE__ \
    , kCIDLib_::pszTitle1 \
    , kCIDLib_::pszTitle2 \
    , err \
    , 0 \
    , 0 \
    , msg \
    , kCIDLib::pszEmptyZStr \
);

#define _KRNLERRPOPUP_(msg,err,kerr) \
TFacCIDLib::PopUpErr \
( \
    __FILE__ \
    , __LINE__ \
    , kCIDLib_::pszTitle1 \
    , kCIDLib_::pszTitle2 \
    , err \
    , kerr.errcId() \
    , kerr.errcHostId() \
    , msg \
    , kCIDLib::pszEmptyZStr \
);

#define _MSGPOPUP_(msg) \
TFacCIDLib::PopUpMsg \
( \
    __FILE__ \
    , __LINE__ \
    , kCIDLib_::pszTitle1 \
    , kCIDLib_::pszTitle2 \
    , msg \
    , kCIDLib::pszEmptyZStr \
);
