//
//  FILE NAME: CIDLib.Hpp
//
//  DESCRIPTION:
//
//  This is the main public header for the facility. It is the single point
//  of contact for the outside world. By including it, they get what we
//  have to offer. It also insures consistent order of inclusion which
//  is needed for the precompiled headers stuff to work.
//
//  AUTHOR: Dean Roddey
//
//  CREATED: 11/23/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  CAVEATS/GOTCHAS:
//

// Avoid multiple inclusion
#if         !defined(_CIDLIB_)
#define     _CIDLIB_

// ----------------------------------------------------------------------------
//  Set up our import/export attributes
// ----------------------------------------------------------------------------
#if     defined(PROJ_CIDLIB)
#define CIDLIBEXP   DLLEXPORT
#define CIDLIBEXT
#else
#define CIDLIBEXP   DLLIMPORT
#define CIDLIBEXT   extern
#endif


// ----------------------------------------------------------------------------
//  Include our underlying headers
// ----------------------------------------------------------------------------
#include    "CIDKernel.Hpp"


// ----------------------------------------------------------------------------
//  Provide null references for most of our classes
// ----------------------------------------------------------------------------
#define NUL_MDuplicable     (*(MDuplicable*)0)
#define NUL_MFormattable    (*(MFormattable*)0)
#define NUL_MStreamable     (*(MStreamable*)0)

#define NUL_T2DVector       (*(T2DVector*)0)
#define NUL_T3DVector       (*(T3DVector*)0)
#define NUL_T4By4Matrix     (*(T4By4Matrix*)0)
#define NUL_TArea           (*(TArea*)0)
#define NUL_TAudio          (*(TAudio*)0)
#define NUL_TBinaryFile     (*(TBinaryFile*)0)
#define NUL_TBinaryStream   (*(TBinaryStream*)0)
#define NUL_TCardinal       (*(TCardinal*)0)
#define NUL_TClass          (*(TClass*)0)
#define NUL_TClrPalette     (*(TClrPalette*)0)
#define NUL_TDirIter        (*(TDirIter*)0)
#define NUL_TEncrypter      (*(TEncrypter*)0)
#define NUL_TEnvironment    (*(TEnvironment*)0)
#define NUL_TError          (*(TError*)0)
#define NUL_TFacility       (*(TFacility*)0)
#define NUL_TFArea          (*(TFArea*)0)
#define NUL_TFileBase       (*(TFileBase*)0)
#define NUL_TFloat          (*(TFloat*)0)
#define NUL_TInteger        (*(TInteger*)0)
#define NUL_TLogger         (*(TLogger*)0)
#define NUL_TMemBuf         (*(TMemBuf*)0)
#define NUL_TMetricGroup    (*(TMetricGroup*)0)
#define NUL_TModule         (*(TModule*)0)
#define NUL_TMoney          (*(TMoney*)0)
#define NUL_TPathStr        (*(TPathStr*)0)
#define NUL_TPoint          (*(TPoint*)0)
#define NUL_TRange          (*(TRange*)0)
#define NUL_TResourceName   (*(TResourceName*)0)
#define NUL_TSemaphore      (*(TSemaphore*)0)
#define NUL_TStatusController (*(TStatusController*)0)
#define NUL_TSharedMemBuf   (*(TSharedMemBuf*)0)
#define NUL_TSize           (*(TSize*)0)
#define NUL_TString         (*(TString*)0)
#define NUL_TStreamFmt      (*(TStreamFmt*)0)
#define NUL_TSysInfo        (*(TSysInfo*)0)
#define NUL_TTextStream     (*(TTextStream*)0)
#define NUL_TThread         (*(TThread*)0)
#define NUL_TTime           (*(TTime*)0)
#define NUL_TValueMap       (*(TValueMap*)0)


// ----------------------------------------------------------------------------
//  Now subinclude our other headers, in the needed order. We first do some
//  some very core files.
// ----------------------------------------------------------------------------
#include    "CIDLib_RTTI.Hpp"
#include    "CIDLib_Duplicable.Hpp"
#include    "CIDLib_Formattable.Hpp"
#include    "CIDLib_Streamable.Hpp"
#include    "CIDLib_Type.Hpp"
#include    "CIDLib_Object.Hpp"
#include    "CIDLib_Class.Hpp"
#include    "CIDLib_Lock.Hpp"
#include    "CIDLib_ResourceIds.H"
#include    "CIDLib_BaseLock.Hpp"
#include    "CIDLib_MutexLock.Hpp"
#include    "CIDLib_ErrorIds.Hpp"
#include    "CIDLib_String.Hpp"
#include    "CIDLib_Module.Hpp"
#include    "CIDLib_Facility.Hpp"
#include    "CIDLib_ResourceName.Hpp"
#include    "CIDLib_Mutex.Hpp"

#include    "CIDLib_Comparator.Hpp"
#include    "CIDLib_DLinkedList.Hpp"
#include    "CIDLib_SLinkedList.Hpp"
#include    "CIDLib_CollectCursor.Hpp"
#include    "CIDLib_Collection.Hpp"

#include    "CIDLib_2DVector.Hpp"
#include    "CIDLib_3DVector.Hpp"
#include    "CIDLib_4By4Matrix.Hpp"
#include    "CIDLib_Point.Hpp"
#include    "CIDLib_Size.Hpp"
#include    "CIDLib_Area.Hpp"
#include    "CIDLib_BaseAudio.Hpp"
#include    "CIDLib_Cardinal.Hpp"
#include    "CIDLib_CriticalSection.Hpp"
#include    "CIDLib_Float.Hpp"
#include    "CIDLib_Integer.Hpp"
#include    "CIDLib_Color.Hpp"
#include    "CIDLib_ColorPalette.Hpp"
#include    "CIDLib_CountedPointer.Hpp"
#include    "CIDLib_BinaryStream.Hpp"
#include    "CIDLib_StreamFmt.Hpp"
#include    "CIDLib_TextStream.Hpp"
#include    "CIDLib_ThisFacility.Hpp"
#include    "CIDLib_Time.Hpp"
#include    "CIDLib_PathString.Hpp"
#include    "CIDLib_FileBase.Hpp"
#include    "CIDLib_BinaryFile.Hpp"
#include    "CIDLib_Encrypt.Hpp"
#include    "CIDLib_Error.Hpp"
#include    "CIDLib_Event.Hpp"
#include    "CIDLib_FArea.Hpp"
#include    "CIDLib_VolumeInfo.Hpp"
#include    "CIDLib_FileStreamImpl.Hpp"
#include    "CIDLib_BinaryFileStream.Hpp"
#include    "CIDLib_BinaryMBufStream.Hpp"
#include    "CIDLib_Handle.Hpp"
#include    "CIDLib_Locale.Hpp"
#include    "CIDLib_Logger.Hpp"
#include    "CIDLib_Memory.Hpp"
#include    "CIDLib_MemoryStreamImpl.Hpp"
#include    "CIDLib_Metrics.Hpp"
#include    "CIDLib_Money.Hpp"
#include    "CIDLib_FileLogger.Hpp"
#include    "CIDLib_PolyStreamer.Hpp"
#include    "CIDLib_PopUpLogger.Hpp"
#include    "CIDLib_Pointer.Hpp"
#include    "CIDLib_Range.Hpp"
#include    "CIDLib_SafeCounter.Hpp"
#include    "CIDLib_Semaphore.Hpp"
#include    "CIDLib_StatusController.Hpp"
#include    "CIDLib_SharedMemory.Hpp"
#include    "CIDLib_StdOutLogger.Hpp"
#include    "CIDLib_StringStreamImpl.Hpp"
#include    "CIDLib_SystemInfo.Hpp"
#include    "CIDLib_TextFileLogger.Hpp"
#include    "CIDLib_TextFileStream.Hpp"
#include    "CIDLib_TextMBufStream.Hpp"
#include    "CIDLib_StringStream.Hpp"
#include    "CIDLib_Thread.Hpp"
#include    "CIDLib_UniqueName.Hpp"
#include    "CIDLib_ValueMap.Hpp"
#include    "CIDLib_ValueMap2.Hpp"

#include    "CIDLib_BaseArray.Hpp"
#include    "CIDLib_Console.Hpp"
#include    "CIDLib_ProcessRegistry.Hpp"
#include    "CIDLib_StatusControllerTTY.Hpp"
#include    "CIDLib_TypedMBuf.Hpp"

// ----------------------------------------------------------------------------
//  Export the facility object. This stuff is defined in the main module.
// ----------------------------------------------------------------------------
extern CIDLIBEXP TFacCIDLib  facCIDLib;

#include    "CIDLib_KeyOps.Hpp"

#include    "CIDLib_Bag.Hpp"
#include    "CIDLib_Deque.Hpp"
#include    "CIDLib_ObjectArray.Hpp"
#include    "CIDLib_Queue.Hpp"
#include    "CIDLib_Stack.Hpp"
#include    "CIDLib_HashMap.Hpp"
#include    "CIDLib_HashSet.Hpp"
#include    "CIDLib_SortedBag.Hpp"
#include    "CIDLib_CollectSearch.Hpp"
#include    "CIDLib_FindBuf.Hpp"
#include    "CIDLib_DirIter.Hpp"
#include    "CIDLib_StreamParser.Hpp"
#include    "CIDLib_FileSystem.Hpp"

#include    "CIDLib_Environment.Hpp"
#include    "CIDLib_ExternalProcess.Hpp"


// ----------------------------------------------------------------------------
//  Because of the special nature of this facility at the base of the
//  system, order of inclusion problems arise. Therefore, this stuff is
//  done here instead of in xxxx_Types.Hpp file, where it is in all other
//  facilities.
// ----------------------------------------------------------------------------
#if !defined(CIDLIB_NOCLASSES)

EnumStreamMacros(tCIDLib::EAngleTypes)
EnumStreamMacros(tCIDLib::EAutoModes)
EnumStreamMacros(tCIDLib::EAudioCues)
EnumStreamMacros(tCIDLib::ECPUTypes)
EnumStreamMacros(tCIDLib::EDeleteModes)
EnumStreamMacros(tCIDLib::EEnds)
EnumStreamMacros(tCIDLib::EErrClasses)
EnumStreamMacros(tCIDLib::EExitCodes)
EnumStreamMacros(tCIDLib::EEventStates)
EnumStreamMacros(tCIDLib::EFileAttrs)
EnumStreamMacros(tCIDLib::EHJustify)
EnumStreamMacros(tCIDLib::ELockStates)
EnumStreamMacros(tCIDLib::ELogMapModes)
EnumStreamMacros(tCIDLib::EMatrixElems)
EnumStreamMacros(tCIDLib::EMetricTypes)
EnumStreamMacros(tCIDLib::EMonths)
EnumStreamMacros(tCIDLib::EProcStates)
EnumStreamMacros(tCIDLib::EPrioClasses)
EnumStreamMacros(tCIDLib::EPrioLevels)
EnumStreamMacros(tCIDLib::ERadices)
EnumStreamMacros(tCIDLib::ERscTypes)
EnumStreamMacros(tCIDLib::ESeverities)
EnumStreamMacros(tCIDLib::EShareStates)
EnumStreamMacros(tCIDLib::ESymmetries)
EnumStreamMacros(tCIDLib::ESysExcepts)
EnumStreamMacros(tCIDLib::ETrailFormats)
EnumStreamMacros(tCIDLib::ETriStates)
EnumStreamMacros(tCIDLib::EVJustify)
EnumStreamMacros(tCIDLib::EWeekDays)

EnumBinStreamMacros(tCIDLib::EAccessModes)
EnumBinStreamMacros(tCIDLib::EMemAccFlags)

#endif


// ----------------------------------------------------------------------------
//  The client program defines the CIDLib_MainModule() token, which causes
//  our special startup code to be included.
// ----------------------------------------------------------------------------
extern tCIDLib::TVoid CIDLIBEXP CIDLib_Init();
extern tCIDLib::EExitCodes CIDLIBEXP CIDLib_MTHibernate();
extern tCIDLib::TVoid CIDLIBEXP CIDLib_MakePrimary(TThread* const);


#define CIDLib_MainModule(thrCtor) \
extern "C" int wmain(); \
int wmain() \
{ \
    CIDLib_Init(); \
    TThread* pthrToStart = new thrCtor; \
    CIDLib_MakePrimary(pthrToStart); \
    TProcessRegistry::SetProcessState(tCIDLib::EProcState_EnteredMainThread); \
    pthrToStart->Start(); \
    return (int)CIDLib_MTHibernate(); \
}

#endif
