//
//  FILE NAME: CIDKernel_UniCode.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/06/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This header contains the constants for a lot of the UniCode characters
//  that people will need to refer to and there is no convenient way to
//  do so within the actual source code such that its portable. Or, in
//  many cases, its just more self documenting and readable to use these
//  named values.
//
//  This file is included within the kCIDLib namespace because its just
//  constants, but there were enough of them that we want to keep them
//  in a separate file.
//

namespace kCIDLib
{
    // Standard control characters
    const   tCIDLib::Tch    chNull          = 0x0000;
    const   tCIDLib::Tch    chBS            = 0x0008;
    const   tCIDLib::Tch    chTab           = 0x0009;
    const   tCIDLib::Tch    chLF            = 0x000A;
    const   tCIDLib::Tch    chVTab          = 0x000B;
    const   tCIDLib::Tch    chFF            = 0x000C;
    const   tCIDLib::Tch    chCR            = 0x000D;
    const   tCIDLib::Tch    chESC           = 0x001B;
    const   tCIDLib::Tch    chSpace         = 0x0020;
    const   tCIDLib::Tch    chDel           = 0x007F;

    // Standard punctuation stuff
    const   tCIDLib::Tch    chExclamation   = 0x0021;
    const   tCIDLib::Tch    chQuotation     = 0x0022;
    const   tCIDLib::Tch    chNumberSign    = 0x0023;
    const   tCIDLib::Tch    chDollarSign    = 0x0024;
    const   tCIDLib::Tch    chPercentSign   = 0x0025;
    const   tCIDLib::Tch    chAmpersand     = 0x0026;
    const   tCIDLib::Tch    chApostrophe    = 0x0027;
    const   tCIDLib::Tch    chOpenParen     = 0x0028;
    const   tCIDLib::Tch    chCloseParen    = 0x0029;
    const   tCIDLib::Tch    chAsterisk      = 0x002A;
    const   tCIDLib::Tch    chPlusSign      = 0x002B;
    const   tCIDLib::Tch    chComma         = 0x002C;
    const   tCIDLib::Tch    chHyphenMinus   = 0x002D;
    const   tCIDLib::Tch    chPeriod        = 0x002E;
    const   tCIDLib::Tch    chSlash         = 0x002F;
    const   tCIDLib::Tch    chColon         = 0x003A;
    const   tCIDLib::Tch    chSemiColon     = 0x003B;
    const   tCIDLib::Tch    chLessThan      = 0x003C;
    const   tCIDLib::Tch    chEquals        = 0x003D;
    const   tCIDLib::Tch    chGreaterThan   = 0x003E;
    const   tCIDLib::Tch    chQuestionMark  = 0x003F;
    const   tCIDLib::Tch    chAtSign        = 0x0040;
    const   tCIDLib::Tch    chOpenBracket   = 0x005B;
    const   tCIDLib::Tch    chBackSlash     = 0x005C;
    const   tCIDLib::Tch    chCloseBracket  = 0x005D;
    const   tCIDLib::Tch    chCircumflex    = 0x005E;
    const   tCIDLib::Tch    chUnderscore    = 0x005F;
    const   tCIDLib::Tch    chGrave         = 0x0060;
    const   tCIDLib::Tch    chOpenBrace     = 0x007B;
    const   tCIDLib::Tch    chVerticalBar   = 0x007C;
    const   tCIDLib::Tch    chCloseBrace    = 0x007D;
    const   tCIDLib::Tch    chTilde         = 0x007E;


    // Capital Latin letters
    const   tCIDLib::Tch    chLatin_A       = 0x0041;
    const   tCIDLib::Tch    chLatin_B       = 0x0042;
    const   tCIDLib::Tch    chLatin_C       = 0x0043;
    const   tCIDLib::Tch    chLatin_D       = 0x0044;
    const   tCIDLib::Tch    chLatin_E       = 0x0045;
    const   tCIDLib::Tch    chLatin_F       = 0x0046;
    const   tCIDLib::Tch    chLatin_G       = 0x0047;
    const   tCIDLib::Tch    chLatin_H       = 0x0048;
    const   tCIDLib::Tch    chLatin_I       = 0x0049;
    const   tCIDLib::Tch    chLatin_J       = 0x004A;
    const   tCIDLib::Tch    chLatin_K       = 0x004B;
    const   tCIDLib::Tch    chLatin_L       = 0x004C;
    const   tCIDLib::Tch    chLatin_M       = 0x004D;
    const   tCIDLib::Tch    chLatin_N       = 0x004E;
    const   tCIDLib::Tch    chLatin_O       = 0x004F;
    const   tCIDLib::Tch    chLatin_P       = 0x0050;
    const   tCIDLib::Tch    chLatin_Q       = 0x0051;
    const   tCIDLib::Tch    chLatin_R       = 0x0052;
    const   tCIDLib::Tch    chLatin_S       = 0x0053;
    const   tCIDLib::Tch    chLatin_T       = 0x0054;
    const   tCIDLib::Tch    chLatin_U       = 0x0055;
    const   tCIDLib::Tch    chLatin_V       = 0x0056;
    const   tCIDLib::Tch    chLatin_W       = 0x0057;
    const   tCIDLib::Tch    chLatin_X       = 0x0058;
    const   tCIDLib::Tch    chLatin_Y       = 0x0059;
    const   tCIDLib::Tch    chLatin_Z       = 0x005A;

    // Lower case Latin letters
    const   tCIDLib::Tch    chLatin_a       = 0x0061;
    const   tCIDLib::Tch    chLatin_b       = 0x0062;
    const   tCIDLib::Tch    chLatin_c       = 0x0063;
    const   tCIDLib::Tch    chLatin_d       = 0x0064;
    const   tCIDLib::Tch    chLatin_e       = 0x0065;
    const   tCIDLib::Tch    chLatin_f       = 0x0066;
    const   tCIDLib::Tch    chLatin_g       = 0x0067;
    const   tCIDLib::Tch    chLatin_h       = 0x0068;
    const   tCIDLib::Tch    chLatin_i       = 0x0069;
    const   tCIDLib::Tch    chLatin_j       = 0x006A;
    const   tCIDLib::Tch    chLatin_k       = 0x006B;
    const   tCIDLib::Tch    chLatin_l       = 0x006C;
    const   tCIDLib::Tch    chLatin_m       = 0x006D;
    const   tCIDLib::Tch    chLatin_n       = 0x006E;
    const   tCIDLib::Tch    chLatin_o       = 0x006F;
    const   tCIDLib::Tch    chLatin_p       = 0x0070;
    const   tCIDLib::Tch    chLatin_q       = 0x0071;
    const   tCIDLib::Tch    chLatin_r       = 0x0072;
    const   tCIDLib::Tch    chLatin_s       = 0x0073;
    const   tCIDLib::Tch    chLatin_t       = 0x0074;
    const   tCIDLib::Tch    chLatin_u       = 0x0075;
    const   tCIDLib::Tch    chLatin_v       = 0x0076;
    const   tCIDLib::Tch    chLatin_w       = 0x0077;
    const   tCIDLib::Tch    chLatin_x       = 0x0078;
    const   tCIDLib::Tch    chLatin_y       = 0x0079;
    const   tCIDLib::Tch    chLatin_z       = 0x007A;

    // Arabic digits
    const   tCIDLib::Tch    chDigit0        = 0x0030;
    const   tCIDLib::Tch    chDigit1        = 0x0031;
    const   tCIDLib::Tch    chDigit2        = 0x0032;
    const   tCIDLib::Tch    chDigit3        = 0x0033;
    const   tCIDLib::Tch    chDigit4        = 0x0034;
    const   tCIDLib::Tch    chDigit5        = 0x0035;
    const   tCIDLib::Tch    chDigit6        = 0x0036;
    const   tCIDLib::Tch    chDigit7        = 0x0037;
    const   tCIDLib::Tch    chDigit8        = 0x0038;
    const   tCIDLib::Tch    chDigit9        = 0x0039;


    //
    //  These are defined formatting characters.
    //
    const   tCIDLib::Tch    chLineSeparator = 0x2028;
    const   tCIDLib::Tch    chParaSeparator = 0x2029;

    //
    //  These are special characters used to indicate special circumstances
    //  to readers/writes of UNICode text files.
    //
    const   tCIDLib::Tch    chReplacement   = 0xFFFD;
    const   tCIDLib::Tch    chMarker        = 0xFEFF;
    const   tCIDLib::Tch    chSwappedMarker = 0xFFFE;
    const   tCIDLib::Tch    chInvalid       = 0xFFFF;
};
