//
//  FILE NAME: CIDKernel_Type.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/06/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This file is the main types file of the facility. Since this is the
//  core facility, it has all of the fundamental stuff. We use the name
//  space system to make this stuff fit into the CIDLib.Dll facility's
//  name spaces, since this facility is really hidden from end users.
//
//  CAVEATS/GOTCHAS:
//
//  1)  This file might be used by some simple, external programs that
//      want to interface to some CIDLib data. So it supports the
//      CIDKRNL_NOCLASSES conditional. If its defined, then only non-class
//      stuff is included here.
//


// ----------------------------------------------------------------------------
//  Define some system keywords for easy translation in the future
// ----------------------------------------------------------------------------
#define ASMCALL         __stdcall
#define DLLINITAPI      __stdcall
#define THREADCALL      __stdcall
#define CALLBACKFUNC    __stdcall
#define DLLEXPORT       __declspec(dllexport)
#define DLLIMPORT       __declspec(dllimport)
#define THREADVAR       __declspec(thread)
#define WNDPROCAPI      __stdcall


// ----------------------------------------------------------------------------
//  Forward reference some platform types. On NT we use STRICT on the kernel
//  so the handles are actually often pointers to structures.
// ----------------------------------------------------------------------------
struct HBITMAP__;
struct HICON__;
struct HINSTANCE__;
struct HRSRC__;
struct HKEY__;


#if !defined(CIDKRNL_NOCLASSES)
// ----------------------------------------------------------------------------
//  Forward reference some types that are used here but not actually defined
//  until CIDLib.Dll
// ----------------------------------------------------------------------------
class   TObject;
class   TThread;
class   TModule;
#endif


namespace tCIDLib
{
    // ------------------------------------------------------------------------
    //  These are our versions of the fundamental data types. We provide very
    //  explicit sizes for all fundamental types using the number of bytes it
    //  takes. Also we define a nul reference macro for each fundamental
    //  type.
    //
    //  NOTE:   Our default character is a UNICODE character! There is the
    //          sch (short character) type for those situations where we
    //          have to import ascii text.
    //
    //  Prefixes: b, ch, sch, c1, c2, c4, f4, f8, i1, i2, i4, i8 respectively
    // ------------------------------------------------------------------------
    typedef bool			TBoolean;
    #define NUL_TBoolean    (*(tCIDLib::TBoolean*)0)

    typedef unsigned short  Tch;
    #define NUL_Tch         (*(tCIDLib::Tch*)0)

    typedef char            Tsch;
    #define NUL_Tsch         (*(tCIDLib::Tsch*)0)

    typedef unsigned char   TCard1;
    #define NUL_TCard1      (*(tCIDLib::TCard1*)0)

    typedef unsigned short  TCard2;
    #define NUL_TCard2      (*(tCIDLib::TCard2*)0)

    typedef unsigned long   TCard4;
    #define NUL_TCard4      (*(tCIDLib::TCard4*)0)

    typedef float           TFloat4;
    #define NUL_TFloat4     (*(tCIDLib::Float4*)0)

    typedef double          TFloat8;
    #define NUL_TFloat8     (*(tCIDLib::Float8*)0)

    typedef signed char     TInt1;
    #define NUL_TInt1       (*(tCIDLib::TInt1*)0)

    typedef short int       TInt2;
    #define NUL_TInt2       (*(tCIDLib::TInt2*)0)

    typedef long int        TInt4;
    #define NUL_TInt4       (*(tCIDLib::TInt4*)0)

    typedef __int64         TInt8;
    #define NUL_TInt8       (*(tCIDLib::TInt8*)0)


    // There is no prefix for void
    typedef void            TVoid;


    // ------------------------------------------------------------------------
    //  We occasionaly need these when interfacing to 3rd party code or OS.
    //  They are depricated in most cases because they are sized according
    //  to platform.
    //
    //  Pefixes are i and u respectively.
    // ------------------------------------------------------------------------
    typedef int             TSInt;
    typedef unsigned        TUInt;


    // ------------------------------------------------------------------------
    //  Some specially named versions of some fundamental types
    //
    //  These values are for:
    //
    //      1) All hash values in the CIDLib system
    //      2) File positions, sizes, and offsets
    //      3) A CIDLib error code
    //      4) A host OS error code
    //      5) A host resource id
    //      6) A CIDLib message id
    //
    //  Prefixes are: hsh, fpos, errc, errc, rid, mid
    // ------------------------------------------------------------------------
    typedef TCard4          THashVal;
    #define NUL_THashVal    (*(tCIDLib::THashVal*)0)

    typedef __int64         TFilePos;
    #define NUL_TFilePos    (*(tCIDLib::TFilePos*)0)

    typedef TCard4          TErrCode;
    #define NUL_TErrCode    (*(tCIDLib::TErrCode*)0)

    typedef TCard4          TOSErrCode;
    #define NUL_TOSErrCode  (*(tCIDLib::TOSErrCode*)0)

    typedef TCard4          TResId;
    #define NUL_TResId      (*(tCIDLib::TResId*)0)

    typedef TCard4          TMsgId;
    #define NUL_TMsgId      (*(tCIDLib::TMsgId*)0)



    // ------------------------------------------------------------------------
    //  Some system types that we need to interact with sometimes.
    // ------------------------------------------------------------------------
    typedef TVoid*          THandle;

    typedef HBITMAP__*      TBmpHandle;         // hbmp
    typedef THandle         TDirHandle;         // hdir
    typedef THandle         TFileHandle;        // hfl
    typedef THandle         TEventHandle;       // hev
    typedef THandle         TFontHandle;        // hfnt
    typedef HICON__*        TIconHandle;        // hicon
    typedef THandle         TMemHandle;         // hmem
    typedef HINSTANCE__*    TModHandle;         // hmod
    typedef TSInt           TMsgResult;         // mres
    typedef THandle         TMtxHandle;         // hmtx
    typedef THandle         TProcessHandle;     // hproc
    typedef TCard4          TProcessId;         // pid
    typedef HKEY__*         TRegKeyHandle;      // hrkey
    typedef HRSRC__*        TRscHandle;         // hrsc
    typedef THandle         TSemHandle;         // hsem
    typedef THandle         TThreadHandle;      // hthr
    typedef TCard4          TThreadId;          // tid


    // ------------------------------------------------------------------------
    //  Define some fixed length asciiz string types. They are all one character
    //  larger than their name, to leave space for the nul.
    // ------------------------------------------------------------------------
    typedef Tch             TZStr8[9];
    typedef Tch             TZStr16[17];
    typedef Tch             TZStr32[33];
    typedef Tch             TZStr64[65];
    typedef Tch             TZStr80[81];
    typedef Tch             TZStr128[129];
    typedef Tch             TZStr256[257];
    typedef Tch             TZStr512[513];
    typedef Tch             TZStr1K[1025];



    // ------------------------------------------------------------------------
    //  The adopt/noadopt possiblities
    // ------------------------------------------------------------------------
    enum EAdoptOpts
    {
        EAdoptOpt_NoAdopt
        , EAdoptOpt_Adopt
    };


    // ------------------------------------------------------------------------
    //  The standard read/write access modes. These are mapped internally
    //  to whatever the particular subsystem defines on the OS.
    // ------------------------------------------------------------------------
    enum EAccessModes
    {
        EAccess_None                = 0x0
        , EAccess_Read              = 0x01
        , EAccess_Write             = 0x02
        
        , EAccess_DenyRead          = 0x10
        , EAccess_DenyWrite         = 0x20

        // Convenient combos
        , EAccess_ReadWrite         = 0x03
        , EAccess_Excl_Read         = 0x31
        , EAccess_Excl_Write        = 0x32
        , EAccess_Excl_ReadWrite    = 0x33
    };


    // --------------------------------------------------------------------
    //  This enum is used to indicate whether angles are in radians or
    //  degrees.
    // --------------------------------------------------------------------
    enum EAngleTypes
    {
        EAngle_Radians
        , EAngle_Degrees

        , EAngleTypes_Count
        , EAngleTypes_Min           = EAngle_Radians
        , EAngleTypes_Max           = EAngle_Degrees
    };


    // ------------------------------------------------------------------------
    //  The possible types of audible cues that can be requested from an
    //  TAudio object. Everyone does basic audio cues via the facCIDLib facility
    //  object which has a single, public TAudio object. This object can be
    //  replaced by higher level code to say, map the cues to a multimedia
    //  layer (and then add lots of other functionality.) The default version
    //  just uses the speaker.
    // ------------------------------------------------------------------------
    enum EAudioCues
    {
        EAudioCue_Alert
        , EAudioCue_Bell
        , EAudioCue_Click
        , EAudioCue_Chime
        , EAudioCue_Error
        , EAudioCue_HiPulse
        , EAudioCue_Information
        , EAudioCue_LowPulse
        , EAudioCue_MedPulse
        , EAudioCue_Question
        , EAudioCue_Rising
        , EAudioCue_Sinking
        , EAudioCue_Warning
    };


    // ------------------------------------------------------------------------
    //  The possible settings of an auto/manual flag
    // ------------------------------------------------------------------------
    enum EAutoModes
    {
        EAutoMode_Manual
        , EAutoMode_Automatic

        , EAutoModes_Count
        , EAutoModes_Min            = EAutoMode_Manual
        , EAutoModes_Max            = EAutoMode_Automatic
    };


    // ------------------------------------------------------------------------
    //  The CPU types that we know about and can run on, ect... This value
    //  is returned by the TSysInfo::ECPUType() method of the Kernel facility.
    // ------------------------------------------------------------------------
    enum ECPUTypes
    {
        ECPUType_Unknown
        , ECPUType_386DX
        , ECPUType_486DX
        , ECPUType_Pentium
        , ECPUType_R4000
        , ECPUType_Alpha

        , ECPUTypes_Count
        , ECPUTypes_Min             = ECPUType_Unknown
        , ECPUTypes_Max             = ECPUType_Alpha
    };


    // ------------------------------------------------------------------------
    //  These are flags used when creating or opening files or other
    //  resources that may already exist. It tells the open method how to
    //  react to an existing or non-existent resource.
    // ------------------------------------------------------------------------
    enum ECreateActions
    {
        ECreateAct_None
        , ECreateAct_CreateIfNew
        , ECreateAct_ReplaceIfExists
        , ECreateAct_OpenIfExists
        , ECreateAct_OpenOrCreate
        , ECreateAct_TruncateIfExists
        , ECreateAct_FailIfExists
    };


    // -----------------------------------------------------------------------
    //  The default palettes that we provide. TClrPalette can construct
    //  from one of these values to get them.
    // -----------------------------------------------------------------------
    enum EDefPalettes
    {
        EDefPalette_BlackAndWhite
        , EDefPalette_16Default
        , EDefPalette_16GrayScale
        , EDefPalette_256Default
        , EDefPalette_256GrayScale
    };


    // ------------------------------------------------------------------------
    //  This is used to indicate delete options to any methods that require
    //  such control.
    // ------------------------------------------------------------------------
    enum EDeleteModes
    {
        EDel_NoDelete
        , EDel_Default
        , EDel_Delete

        , EDeleteModes_Count
        , EDeleteModes_Min          = EDel_NoDelete
        , EDeleteModes_Max          = EDel_Delete
    };


    // ------------------------------------------------------------------------
    //  The gross level types of drives
    // ------------------------------------------------------------------------
    enum EDriveTypes
    {
        EDriveType_Unknown
        , EDriveType_Removable
        , EDriveType_Fixed
        , EDriveType_Remote
        , EDriveType_CD
        , EDriveType_RAMDisk

        , EDriveTypes_Count
        , EDriveTypes_Min           = EDriveType_Unknown
        , EDriveTypes_Max           = EDriveType_RAMDisk
    };


    // -----------------------------------------------------------------------
    //  The possible 'endian' modes of the host machine
    // -----------------------------------------------------------------------
    enum EEndianModes
    {
        EEndianMode_Little
        , EEndianMode_Big
    };


    // -----------------------------------------------------------------------
    //  The possible error classes
    // -----------------------------------------------------------------------
    enum EErrClasses
    {
        EClass_None

        , EClass_OutResource
        , EClass_TempSituation
        , EClass_Authority
        , EClass_Internal
        , EClass_HardwareFailure
        , EClass_SystemFailure
        , EClass_AppError
        , EClass_NotFound
        , EClass_BadParms
        , EClass_Locked
        , EClass_Media
        , EClass_Already
        , EClass_Unknown
        , EClass_CantDo
        , EClass_Timeout
        , EClass_DynamicType
        , EClass_TypeMatch
        , EClass_StreamFormat
        , EClass_UserInput
        , EClass_NotReady
        , EClass_AppStatus

        , EErrClasses_Count
        , EErrClasses_Min           = EClass_None
        , EErrClasses_Max           = EClass_AppStatus
    };


    // ------------------------------------------------------------------------
    //  The possible ends of any two ended thing
    // ------------------------------------------------------------------------
    enum EEnds
    {
        EEnd_First
        , EEnd_Last

        , EEnds_Count
        , EEnds_Min                 = EEnd_First
        , EEnds_Max                 = EEnd_Last
    };


    // ------------------------------------------------------------------------
    //  The states of an event
    // ------------------------------------------------------------------------
    enum EEventStates
    {
        EEventState_Reset
        , EEventState_Triggered

        , EEventStates_Count
        , EEventStates_Min
        , EEventStates_Max
    };


    // -----------------------------------------------------------------------
    //  The standard exit codes that CIDLib will use, and which are 
    //  recommended for CIDLib apps. All the lower numbers are left open
    //  for user use (just cast your value to this type.)
    // -----------------------------------------------------------------------
    enum EExitCodes
    {
        EExit_Normal                = 0

        , EExit_AdminRestart        = 1001
        , EExit_FatalError          = 1002
        , EExit_RuntimeError        = 1003
        , EExit_SystemException     = 1004
        , EExit_BadParameters       = 1005
        , EExit_ResourceAccess      = 1006
        , EExit_PermissionLevel     = 1007
        , EExit_NotFound            = 1008
        , EExit_InitFailed          = 1009

        , EExitCodes_FirstNamed     = 1001
        , EExitCodes_LastNamed      = 1009
    };


    // -----------------------------------------------------------------------
    //  These are the possible loadable module types.
    // -----------------------------------------------------------------------
    enum EModTypes
    {
        EModType_Dll
        , EModType_Exe
    };


    // ------------------------------------------------------------------------
    //  The standard attributes of a file.
    // ------------------------------------------------------------------------
    enum EFileAttrs
    {
        EFileAttr_None              = 0
        , EFileAttr_ReadOnly        = 0x00000001
        , EFileAttr_Hidden          = 0x00000002
        , EFileAttr_System          = 0x00000004
        , EFileAttr_Directory       = 0x00000010
        , EFileAttr_Archive         = 0x00000020
        , EFileAttr_Compressed      = 0x00000800

        // Some common combos
        , EFileAttr_HiddenSystem    = 0x00000006
        , EFileAttr_HiddenSystemRead= 0x00000007
        , EFileAttr_SystemReadOnly  = 0x00000005
        , EFileAttr_All             = 0x00000837
    };


    // ------------------------------------------------------------------------
    //  The standard file control flags, which control various attributes of
    //  an opened or created file.
    // ------------------------------------------------------------------------
    enum EFileFlags
    {
        EFileFlag_None              = 0x0
        , EFileFlag_WriteThrough    = 0x80000000
        , EFileFlag_Overlapped      = 0x40000000
        , EFileFlag_NoBuffering     = 0x20000000
        , EFileFlag_RandomAccess    = 0x10000000
        , EFileFlag_SequentialScan  = 0x08000000
        , EFileFlag_DeleteOnClose   = 0x04000000
        , EFileFlag_BackupSemantics = 0x02000000
    };


    // -----------------------------------------------------------------------
    //  These are returned by the file system volume information classes.
    //  They indicate various attributes of the volume.
    // -----------------------------------------------------------------------
    enum EFileSysFlags
    {
        EFlSysFlag_None             = 0x00000000
        , EFlSysFlag_CaseSensitve   = 0x00000001
        , EFlSysFlag_CasePreserved  = 0x00000002
        , EFlSysFlag_UNICodeNames   = 0x00000004
        , EFlSysFlag_SavesACLS      = 0x00000008
        , EFlSysFlag_FileCompress   = 0x00000010
        , EFlSysFlag_VolCompress    = 0x00008000
    };


    // -----------------------------------------------------------------------
    //  The force/noforce type of option that many functions support, to
    //  either force some to happen that otherwise would not, or to not force.
    // ------------------------------------------------------------------------
    enum EForceOpts
    {
        EForce_NoForce
        , EForce_Force

        , EForceOpts_Count
        , EForceOpts_Min            = EForce_NoForce
        , EForceOpts_Max            = EForce_Force
    };


    // ------------------------------------------------------------------------
    //  These are passed to the module init/term functions of Dlls. Each one
    //  is called once for pre-'global ct/dt' time and once after it, since
    //  there is a need for init/term in both cases oftentimes.
    // ------------------------------------------------------------------------
    enum EGlobalStates
    {
        EGlobalState_Before
        , EGlobalState_After
    };


    // ------------------------------------------------------------------------
    //  Horizontal and vertical justification
    // ------------------------------------------------------------------------
    enum EHJustify
    {
        EHJustify_Left
        , EHJustify_Right
        , EHJustify_Center

        , EHJustify_Count
        , EHJustify_Min             = EHJustify_Left
        , EHJustify_Max             = EHJustify_Center
    };

    enum EVJustify
    {
        EVJustify_Bottom
        , EVJustify_Center
        , EVJustify_Top

        , EVJustify_Count
        , EVJustify_Min             = EVJustify_Bottom
        , EVJustify_Max             = EVJustify_Center
    };


    // ------------------------------------------------------------------------
    //  The reasons a module gets initialize
    // ------------------------------------------------------------------------
    enum EInitTerm
    {
        EInitTerm_Terminate         = 0
        , EInitTerm_Initialize      = 1

        , EInitTerm_Count
        , EInitTerm_Min             = EInitTerm_Terminate
        , EInitTerm_Max             = EInitTerm_Initialize
    };


    // ------------------------------------------------------------------------
    //  The state of a locked thing, either locked or unlocked. Its set up
    //  so that unlocked is 0 and locked is non-zero.
    // ------------------------------------------------------------------------
    enum ELockStates
    {
        ELockState_Unlocked
        , ELockState_Locked
    };


    // --------------------------------------------------------------------
    //  The ways that a TLogMap object will style its look up table. If
    //  its ELogMapMode_Spread, then the lower indexes are spread out
    //  smoothly, up until the numbers start hitting more than one input
    //  index per output index.
    // --------------------------------------------------------------------
    enum ELogMapModes
    {
        ELogMapMode_Regular
        , ELogMapMode_Spread

        , ELogMapModes_Count
        , ELogMapModes_Min          = ELogMapMode_Regular
        , ELogMapModes_Max          = ELogMapMode_Spread
    };


    // --------------------------------------------------------------------
    //  This enum is used to index matrices via the subscript operator.
    //  Note that not all elements are available, so we manually set the
    //  enum values.
    // --------------------------------------------------------------------
    enum EMatrixElems
    {
        EMatrix_11
        , EMatrix_12
        , EMatrix_13
        , EMatrix_14
        , EMatrix_21
        , EMatrix_22
        , EMatrix_23
        , EMatrix_24
        , EMatrix_31
        , EMatrix_32
        , EMatrix_33
        , EMatrix_34
        , EMatrix_Xt
        , EMatrix_Yt
        , EMatrix_Zt
        , EMatrix_44

        // The count of elements. Must be in this position!
        , EMatrixElems_Count
        , EMatrixElems_Min          = EMatrix_11
        , EMatrixElems_Max          = EMatrix_44
    };


    // -----------------------------------------------------------------------
    //  Memory buffer access rights and allocation flags. System allocated
    //  memory supports these, not heap allocated memory.
    // -----------------------------------------------------------------------
    enum EMemAccFlags
    {
        EMemAcc_None                = 0x00000001UL
        , EMemAcc_ReadOnly          = 0x00000002UL
        , EMemAcc_ReadWrite         = 0x00000004UL
        , EMemAcc_Execute           = 0x00000010UL
        , EMemAcc_ExecuteRead       = 0x00000020UL
        , EMemAcc_ExecuteReadWrite  = 0x00000040UL
        , EMemAcc_Guard             = 0x00000100UL
    };


    // -----------------------------------------------------------------------
    //  The states of memory regions
    // -----------------------------------------------------------------------
    enum EMemStates
    {
        EMemState_Commit            = 0x00001000UL
        , EMemState_Reserved        = 0x00002000UL
        , EMemState_Free            = 0x00010000UL
    };


    // -----------------------------------------------------------------------
    //  The types of memory regions
    // -----------------------------------------------------------------------
    enum EMemTypes
    {
        EMemType_Private            = 0x00200000UL
        , EMemType_Mapped           = 0x00400000UL
        , EMemType_Image            = 0x01000000UL
    };


    // -----------------------------------------------------------------------
    //  This is an enum that defines the available types of metrics.
    // -----------------------------------------------------------------------
    enum EMetricTypes
    {
        EMetric_Accum
        , EMetric_Cardinal
        , EMetric_FlagSet
        , EMetric_Integer
        , EMetric_Toggle
        , EMetric_TickCounter
        , EMetric_PeakMeter
    };


    // ------------------------------------------------------------------------
    //  The possible safe/unsafe states for anything that can be optionally
    //  threadsafe.
    // ------------------------------------------------------------------------
    enum EMTStates
    {
        EMTState_Unsafe             = 0
        , EMTState_Safe             = 1
    };


    // ------------------------------------------------------------------------
    //  An enumeration for the months of the year
    // ------------------------------------------------------------------------
    enum EMonths
    {
        EMonth_January
        , EMonth_February
        , EMonth_March
        , EMonth_April
        , EMonth_May
        , EMonth_June
        , EMonth_July
        , EMonth_August
        , EMonth_September
        , EMonth_October
        , EMonth_November
        , EMonth_December

        , EMonths_Count
        , EMonths_Min               = EMonth_January
        , EMonths_Max               = EMonth_December
    };


    // ------------------------------------------------------------------------
    //  The types of named resources
    // ------------------------------------------------------------------------
    enum ENamedRscTypes
    {
        ENamedRsc_Event
        , ENamedRsc_Memory
        , ENamedRsc_Mutex
        , ENamedRsc_Semaphore
    };


    // ------------------------------------------------------------------------
    //  The possible formats of a textually formatted color palette. Used
    //  by TClrPalette to inport/export palettes.
    // ------------------------------------------------------------------------
    enum EPalTxtFormats
    {
        EPalFmt_SpaceDelimited_OnePer
        , EPalFmt_SpaceDelimited
        , EPalFmt_CommaDelimited
        , EPalFmt_CommaDelimited_OnePer
    };


    // ------------------------------------------------------------------------
    //  The parts of a file system path
    // ------------------------------------------------------------------------
    enum EPathParts
    {
        EPathPart_Drive             = 0x00000001UL
        , EPathPart_Path            = 0x00000002UL
        , EPathPart_Name            = 0x00000004UL
        , EPathPart_Extension       = 0x00000008UL
        , EPathPart_Node            = 0x00010000UL

        , EPathPart_FromRoot        = 0x0001000EUL
        , EPathPart_FullPath        = 0x0001000FUL
        , EPathPart_NameExt         = 0x0000000CUL
    };


    // ------------------------------------------------------------------------
    //  The available priority classes for processes.
    // ------------------------------------------------------------------------
    enum EPrioClasses
    {
        EPrioClass_IdleTime
        , EPrioClass_Normal
        , EPrioClass_High
        , EPrioClass_RealTime

        , EPrioClasses_Count
        , EPrioClasses_Min          = EPrioClass_IdleTime
        , EPrioClasses_Max          = EPrioClass_RealTime
    };


    // ------------------------------------------------------------------------
    //  The available thread priority levels.
    // ------------------------------------------------------------------------
    enum EPrioLevels
    {
        EPrioLevel_Lowest
        , EPrioLevel_BelowNormal
        , EPrioLevel_Normal
        , EPrioLevel_AboveNormal
        , EPrioLevel_Highest

        , EPrioLevels_Count
        , EPrioLevels_Min           = EPrioLevel_Lowest
        , EPrioLevels_Max           = EPrioLevel_Highest
    };


    // ------------------------------------------------------------------------
    //  These are the process statuses that can be set in the process
    //  registry.
    // ------------------------------------------------------------------------
    enum EProcStates
    {
        EProcState_Initializing
        , EProcState_EnteredMainThread
        , EProcState_Ready
        , EProcState_Terminating
        , EProcState_Dead

        , EProcStates_Count
        , EProcStates_Min           = EProcState_Initializing
        , EProcStates_Max           = EProcState_Dead
    };


    // -----------------------------------------------------------------------
    //  The valid priorities for an element in a queue collection.
    // -----------------------------------------------------------------------
    enum EQPriorities
    {
        EQPrio_0
        , EQPrio_1
        , EQPrio_2
        , EQPrio_3
        , EQPrio_4
        , EQPrio_5
        , EQPrio_6
        , EQPrio_7
        , EQPrio_8
        , EQPrio_9
        , EQPrio_10
        , EQPrio_11
        , EQPrio_12
        , EQPrio_13
        , EQPrio_14
        , EQPrio_15

        , EQPriorities_Count
        , EQPriorities_Min          = EQPrio_0
        , EQPriorities_Max          = EQPrio_15
    };


    // ------------------------------------------------------------------------
    //  The basic radices of numbers. These are the ones that are supported
    //  by the CIDLib system for formatting values.
    // ------------------------------------------------------------------------
    enum ERadices
    {
        ERadix_Bin                  = 2
        , ERadix_Oct                = 8
        , ERadix_Dec                = 10
        , ERadix_Hex                = 16
    };


    // -----------------------------------------------------------------------
    //  The possible states of a value within a range. Its either at the min
    //  or one of the max values, or somewhere in between. None is first so
    //  that being at either end is non-zero.
    // -----------------------------------------------------------------------
    enum ERangeStates
    {
        ERangeState_None
        , ERangeState_Min
        , ERangeState_LegalMax
        , ERangeState_Max
    };


    // ------------------------------------------------------------------------
    //  The recoverable states of something that can be recoverable or
    //  fatal.
    // ------------------------------------------------------------------------
    enum ERecoverable
    {
        ERecover_Recoverable
        , ERecover_Unrecoverable
    };


    // ------------------------------------------------------------------------
    //  These are the possible inclusive/non-inclusive states of a
    //  rectangle
    // ------------------------------------------------------------------------
    enum ERectlTypes
    {
        ERectl_Inclusive
        , ERectl_NonInclusive
    };


    // ------------------------------------------------------------------------
    //  This enum provides two states for allowing redirection or not.
    // ------------------------------------------------------------------------
    enum ERedir
    {
        ERedir_Disallow
        , ERedir_Allow
    };


    // ------------------------------------------------------------------------
    //  The available kinds of access to a registry key
    // ------------------------------------------------------------------------
    enum ERegAccessModes
    {
        ERegAccess_QueryValue       = 0x00000001
        , ERegAccess_SetValue       = 0x00000002
        , ERegAccess_CreateSub      = 0x00000004
        , ERegAccess_EnumSubKeys    = 0x00000008
        , ERegAccess_Read           = 0x00000010
        , ERegAccess_Notify         = 0x00000020
        , ERegAccess_CreateLink     = 0x00000040
        , ERegAccess_Write          = 0x00000082
        , ERegAccess_All            = 0x00000100
    };


    // ------------------------------------------------------------------------
    //  The attributes of a registry key
    // ------------------------------------------------------------------------
    enum ERegFlags
    {
        ERegFlag_NonVolatile
        , ERegFlag_Volatile
    };


    // ------------------------------------------------------------------------
    //  The available resource types
    // ------------------------------------------------------------------------
    enum ERscTypes
    {
        ERscType_None               = 0
        , ERscType_Pointer          = 1
        , ERscType_Bitmap           = 2
        , ERscType_Icon             = 3
        , ERscType_Menu             = 4
        , ERscType_String           = 6
        , ERscType_FontDir          = 7
        , ERscType_Font             = 8
        , ERscType_AccelTable       = 9
        , ERscType_RcData           = 10
        , ERscType_Message          = 11
        , ERscType_GroupCursor      = 12
        , ERscType_GroupIcon        = 15
        , ERscType_Version          = 16
    };


    // ------------------------------------------------------------------------
    //  These are used by the file classes when moving the file pointer.
    // ------------------------------------------------------------------------
    enum ESeekFrom
    {
        ESeekFrom_Start
        , ESeekFrom_Current
        , ESeekFrom_End 
    };


    // ------------------------------------------------------------------------
    //  The severity levels of an error
    // ------------------------------------------------------------------------
    enum ESeverities
    {
        ESev_Information
        , ESev_Warning
        , ESev_APIFailed
        , ESev_ProcessFatal
        , ESev_SystemFatal
        , ESev_Status

        , ESeverities_Count
        , ESeverities_Min           = ESev_Information
        , ESeverities_Max           = ESev_Status
    };


    // ------------------------------------------------------------------------
    //  Public types
    // ------------------------------------------------------------------------
    enum ESignPositions
    {
        ESignPos_Parens
        , ESignPos_SignFirst
        , ESignPos_SignLast
        , ESignPos_BeforeCurrency
        , ESignPos_AfterCurrency

        , ESignPositions_Count
        , ESignPositions_Min        = ESignPos_Parens
        , ESignPositions_Max        = ESignPos_AfterCurrency
    };


    // ------------------------------------------------------------------------
    //  The shared state of any kind any shared resource
    // ------------------------------------------------------------------------
    enum EShareStates
    {
        EShareState_Unshared
        , EShareState_Shared
    };


    // ------------------------------------------------------------------------
    //  The result of a sort comparison operation. Sorts need to know the
    //  relative position of two elements to each other.
    // ------------------------------------------------------------------------
    enum ESortComps
    {
        ESort_FirstLess             = -1
        , ESort_Equal               = 0
        , ESort_FirstGreater        = 1
    };


    // ------------------------------------------------------------------------
    //  Used when sorting things. Indicates the direction of the sort
    // ------------------------------------------------------------------------
    enum ESortDirs
    {
        eSortDir_Ascending
        , eSortDir_Descending
    };


    // ------------------------------------------------------------------------
    //  The standard files that can be opened without an explicit name.
    // ------------------------------------------------------------------------
    enum EStdFiles
    {
        EStdFile_StdOut
        , EStdFile_StdIn
        , EStdFile_RedirError
        , EStdFile_RedirOut
        , EStdFile_RedirIn
    };


    // ------------------------------------------------------------------------
    //  For string stripping methods, indicates where the stripping should
    //  occur and how extreme it should be. Used by TString and its
    //  derivatives.
    // ------------------------------------------------------------------------
    enum EStripModes
    {
        EStripMode_None             = 0x0000
        , EStripMode_Leading        = 0x0001
        , EStripMode_Trailing       = 0x0002
        , EStripMode_LeadTrail      = 0x0003
        , EStripMode_Middle         = 0x0004
        , EStripMode_Total          = 0x0008

        , EStripModes_Count         = 6
        , EStripModes_All           = 0x0007
    };


    // ------------------------------------------------------------------------
    //  The system defined bitmaps
    // ------------------------------------------------------------------------
    enum ESysBitmaps
    {
        ESysBmp_None                = 0
        , ESysBmp_Close             = 32754
        , ESysBmp_UpArrow           = 32753
        , ESysBmp_DownArrow         = 32752
        , ESysBmp_RightArrow        = 32751
        , ESysBmp_LeftArrow         = 32750
        , ESysBmp_Reduce            = 32749
        , ESysBmp_Zoom              = 32748
        , ESysBmp_Restore           = 32747
        , ESysBmp_Reduced           = 32746
        , ESysBmp_Zoomed            = 32745
        , ESysBmp_Restored          = 32744
        , ESysBmp_UpArrowD          = 32743
        , ESysBmp_DownArrowD        = 32742
        , ESysBmp_RightArrowD       = 32741
        , ESysBmp_LeftArrowD        = 32740
        , ESysBmp_MnArrow           = 32739
        , ESysBmp_Combo             = 32738
        , ESysBmp_UpArrowI          = 32737
        , ESysBmp_DownArrowI        = 32736
        , ESysBmp_RightArrowI       = 32735
        , ESysBmp_LeftArrowI        = 32734
        , ESysBmp_Size              = 32766
        , ESysBmp_BtSize            = 32761
        , ESysBmp_Check             = 32760
    };


    // --------------------------------------------------------------------
    //  The available system colors
    // --------------------------------------------------------------------
    enum ESysColors
    {
        ESysClr_None
        , ESysClr_3DLight
        , ESysClr_3DDark
        , ESysClr_ActiveBorder
        , ESysClr_ActiveTitleBgn
        , ESysClr_ActiveTitleText
        , ESysClr_AppWorkspace
        , ESysClr_Background
        , ESysClr_BorderContrast
        , ESysClr_ButtonBgn
        , ESysClr_ButtonText
        , ESysClr_DialogBgn
        , ESysClr_EntryFieldBgn
        , ESysClr_EntryFieldText
        , ESysClr_GrayText
        , ESysClr_HiliteBgn
        , ESysClr_HiliteText
        , ESysClr_IconText
        , ESysClr_InactiveBorder
        , ESysClr_InactiveTitleBgn
        , ESysClr_InactiveTitleText
        , ESysClr_MenuBgn
        , ESysClr_MenuText
        , ESysClr_ScrollBar
        , ESysClr_StaticText
        , ESysClr_TipsBgn
        , ESysClr_TipsText
        , ESysClr_Window
        , ESysClr_WindowFrame
        , ESysClr_WindowText
    };


    // -----------------------------------------------------------------------
    //  The supported reasons for a system exception
    // -----------------------------------------------------------------------
    enum ESysExcepts
    {
        ESysExcept_Unknown

        , ESysExcept_BreakPoint
        , ESysExcept_DataAlignment
        , ESysExcept_Float_Denormal
        , ESysExcept_Float_DivByZero
        , ESysExcept_Float_InexactResult
        , ESysExcept_Float_InvalidOp
        , ESysExcept_Float_Overflow
        , ESysExcept_Float_Stack
        , ESysExcept_Float_Underflow
        , ESysExcept_Int_DivByZero
        , ESysExcept_Int_Overflow
        , ESysExcept_PageLoadFailed
        , ESysExcept_ReadAccess
        , ESysExcept_StackOverflow
        , ESysExcept_WriteAccess

        , ESysExcepts_Count
        , ESysExcepts_Min           = ESysExcept_Unknown
        , ESysExcept_Max            = ESysExcept_WriteAccess
    };


    // -----------------------------------------------------------------------
    //  The supported responses to a system exception.
    // -----------------------------------------------------------------------
    enum ESysExceptRes
    {
        ESysExceptRes_Dismiss
        , ESysExceptRes_Propogate
        , ESysExceptRes_ExecuteHandler
    };


    // ---------------------------------------------------------------------
    //  The possible symmetries that a quadrant oriented system can have.
    // ---------------------------------------------------------------------
    enum ESymmetries
    {
        ESymmetry_None
        , ESymmetry_VerticalFlip
        , ESymmetry_HorizontalFlip
        , ESymmetry_QuadrantFlip

        , ESymmetries_Count
        , ESymmetries_Min           = ESymmetry_None
        , ESymmetries_Max           = ESymmetry_QuadrantFlip
    };


    // -----------------------------------------------------------------------
    //  The types of text formats. This is used primarily by text streams
    //  and files to indicate the format of input being read, or how to
    //  format output going out.
    // -----------------------------------------------------------------------
    enum ETextFormats
    {
        ETextFmt_ASCII
        , ETextFmt_UNICode
    };


    // -----------------------------------------------------------------------
    //  The available thread creation flags
    // -----------------------------------------------------------------------
    enum EThreadFlags
    {
        EThreadFlag_None            = 0
        , EThreadFlag_CreateSuspended=0x00000001
    };


    // -----------------------------------------------------------------------
    //  The ways to handle formatting trailing digits
    // -----------------------------------------------------------------------
    enum ETrailFormats
    {
        ETrail_Zeroes
        , ETrail_Spaces
        , ETrail_Ignore
    };


    // ------------------------------------------------------------------------
    //  The state flags for a three state object
    // ------------------------------------------------------------------------
    enum ETriStates
    {
        ETriState_Off
        , ETriState_On
        , ETriState_Kinda

        , ETriStates_Count
        , ETriStates_Min            = ETriState_Off
        , ETriStates_Max            = ETriState_Kinda
    };


    // ------------------------------------------------------------------------
    //  The possible states for something that can be visible or not
    // ------------------------------------------------------------------------
    enum EVisible
    {
        EVisible_Invisible
        , EVisible_Visible

        , EVisible_Count
        , EVisible_Min              = EVisible_Invisible
        , EVisible_Max              = EVisible_Visible
    };


    // ------------------------------------------------------------------------
    //  An enumeration for the days of the week
    // ------------------------------------------------------------------------
    enum EWeekDays
    {
        EWeekDay_Sunday
        , EWeekDay_Monday
        , EWeekDay_Tuesday
        , EWeekDay_Wednesday
        , EWeekDay_Thursday
        , EWeekDay_Friday
        , EWeekDay_Saturday

        , EWeekDays_Count
        , EWeekDays_Min             = EWeekDay_Sunday
        , EWeekDays_Max             = EWeekDay_Saturday
    };


#if !defined(CIDKRNL_NOCLASSES)

    // ------------------------------------------------------------------------
    //  This is the prototype for a thread exit function. Used by TThread.
    // ------------------------------------------------------------------------
    typedef TVoid (*TExitFuncPtr)
    (
                TThread&
    );

    // ------------------------------------------------------------------------
    //  This is the prototype for a thread function, for those threads that
    //  choose to provide a function instead of overriding _excProcess().
    // ------------------------------------------------------------------------
    typedef tCIDLib::EExitCodes (*TThreadFuncPtr)
    (
                TThread&
        ,       tCIDLib::TVoid*
    );

    // ------------------------------------------------------------------------
    //  This is the prototype for an object factory function, used by the
    //  TClass class.
    // ------------------------------------------------------------------------
    typedef TObject* (*TObjFactory)();


    // ------------------------------------------------------------------------
    //  This is the prototype for a module init function.
    // ------------------------------------------------------------------------
    typedef tCIDLib::TVoid (*TModInitTermFuncPtr)
    (
        const   tCIDLib::EInitTerm      eInitTerm
        , const tCIDLib::EGlobalStates  eGlobals
        , const TModule&                modInit
        , const tCIDLib::TCard4         c4MaxChars
        ,       tCIDLib::Tch* const     pszFailReason
    );


    // ------------------------------------------------------------------------
    //  This is a small record used by the module init scheme
    // ------------------------------------------------------------------------
    #pragma pack(push, CIDLIBPACK)
    struct TModuleInitTermRec
    {
        TModInitTermFuncPtr             pfnInitTermFunc;
        const tCIDLib::Tch*             pszDescription;
        tCIDLib::TMsgId                 midDescription;
    };
    #pragma pack(pop)
#endif


    // ----------------------------------------------------------------------------
    //  These are some structures that must map to the layout of their host
    //  OS equivilents. These must be interopeable with some higher level
    //  structures such as TPoint, TArea and TSize. Having these allows those
    //  higher level modules to avoid importing system headers.
    //
    //  This also lets them not be affected by changes to the member names!
    // ----------------------------------------------------------------------------
    #pragma pack(push, 4)
    struct  THostRectl
    {
        tCIDLib::TInt4  i4Left;
        tCIDLib::TInt4  i4Top;
        tCIDLib::TInt4  i4Right;
        tCIDLib::TInt4  i4Bottom;
    };

    struct THostPoint
    {
        tCIDLib::TInt4  i4X;
        tCIDLib::TInt4  i4Y;
    };

    struct THostSize
    {
        tCIDLib::TInt4  i4CX;
        tCIDLib::TInt4  i4CY;
    };
    #pragma pack(pop)
};
