//
//  FILE NAME: CIDKernel_Process.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/23/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDKernel_Process.Cpp module. This module
//  implements the TKrnlThread class. This is the kernel wrapper to provide
//  access to host threading services.
//
//
//  CAVEATS/GOTCHAS:
//
//  1)  A thread cannot call its own eWaitForDeath() method. That's only
//      for others to call.
//


// ----------------------------------------------------------------------------
//  Forward references
// ----------------------------------------------------------------------------
class   TThread;

#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TKrnlThread
//  PREFIX: kthrd
// ----------------------------------------------------------------------------
class KRNLEXPORT TKrnlThread
{
    public  :
        // --------------------------------------------------------------------
        //  Public class types.
        //
        //  TThreadFuncPtr is the prototype for the thread function that is
        //  needed by the BeginThread method.
        // --------------------------------------------------------------------
        typedef tCIDLib::EExitCodes (THREADCALL *TThrFuncPtr)
        (
                    tCIDLib::TVoid*
        );


        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        TKrnlThread();

        ~TKrnlThread();


        // --------------------------------------------------------------------
        //  Public, static methods
        // --------------------------------------------------------------------
        static tCIDLib::TVoid BeepSpeaker
        (
            const   tCIDLib::TCard4         c4Frequency
            , const tCIDLib::TCard4         c4MilliSeconds
        );

        static tCIDLib::EPrioLevels ePriorityOf
        (
            const   TKrnlThread&            kthrToQuery
        );

        static tCIDLib::TOSErrCode errcGetLast();

        static tCIDLib::TVoid Exit
        (
            const   tCIDLib::EExitCodes     eExitCode
        );

        static tCIDLib::TThreadHandle hthrCaller();

        static tCIDLib::TVoid SetLastError
        (
            const   tCIDLib::TOSErrCode     errcToSet
        );

        static tCIDLib::TVoid Sleep
        (
            const   tCIDLib::TCard4         c4MilliSeconds
        );

        static tCIDLib::TThreadId tidCaller();


        //
        //  These are a;; magic and in CIDKernel_StackDump.Cpp! They
        //  provide exception and runtime dump services.
        //
        static tCIDLib::TVoid DumpException
        (
            const   TKrnlThread&            kthrCaller
            , const tCIDLib::Tch* const     pszThreadName
            , const tCIDLib::TVoid* const   pExceptInfo
        );

        static tCIDLib::TVoid DumpRuntimeError
        (
            const   TKrnlThread&            kthrCaller
            , const tCIDLib::Tch* const     pszThreadName
            , const tCIDLib::Tch* const     pszFacility
            , const tCIDLib::Tch* const     pszError
            , const tCIDLib::Tch* const     pszAuxText
            , const tCIDLib::TErrCode       errcId
            , const tCIDLib::TErrCode       errcKrnlId
            , const tCIDLib::TOSErrCode     errcHostId
            , const tCIDLib::Tch* const     pszFile
            , const tCIDLib::TCard4         c4LineNumber
        );


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid AdoptCaller();

        tCIDLib::TVoid AdoptHandle
        (
            const   tCIDLib::TThreadHandle  hthrToAdopt
            , const tCIDLib::TThreadId      tidAdopted
        );

        tCIDLib::TBoolean bIsRunning() const;

        tCIDLib::TVoid BeginThread
        (
            const   TKrnlThread::TThrFuncPtr pfnFunc
            , const tCIDLib::TCard4         c4StackSize
            ,       tCIDLib::TVoid* const   pData
            , const tCIDLib::EThreadFlags   eFlags
        );

        tCIDLib::EPrioLevels ePriority() const;

        tCIDLib::EExitCodes eQueryExitCode() const;

        tCIDLib::EExitCodes eWaitForDeath
        (
            const   tCIDLib::TCard4         c4MilliSeconds = kCIDLib::c4MaxWait
        )   const;

        tCIDLib::TThreadHandle hthrThis() const;

        tCIDLib::TVoid Orphan();

        tCIDLib::TVoid SetPriority
        (
            const   tCIDLib::EPrioLevels    eLevel
        );

        tCIDLib::TThreadId tidThis() const;



    protected  :
        // --------------------------------------------------------------------
        //  Declare our friends
        // --------------------------------------------------------------------
        friend class TThread;


        // --------------------------------------------------------------------
        //  Protected, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid _SetNotRunning();


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TKrnlThread(const TKrnlThread&);

        tCIDLib::TVoid operator=(const TKrnlThread&);


        // --------------------------------------------------------------------
        //  Private date members
        //
        //  __hthrThis
        //      This is the handle of the thread.
        //
        //  __tidThis
        //      This is the thread id.
        // --------------------------------------------------------------------
        tCIDLib::TThreadHandle  __hthrThis;
        tCIDLib::TThreadId      __tidThis;
};

#pragma pack(pop)



// ----------------------------------------------------------------------------
//  Public, non-virtual methods
// ----------------------------------------------------------------------------
inline tCIDLib::TThreadHandle TKrnlThread::hthrThis() const
{
    return __hthrThis;
}

inline tCIDLib::TThreadId TKrnlThread::tidThis() const
{
    return __tidThis;
}

inline tCIDLib::TVoid TKrnlThread::Orphan()
{
    __tidThis = kCIDLib::tidInvalid;
    __hthrThis = kCIDLib::hthrInvalid;
}


// ----------------------------------------------------------------------------
//  Protected, non-virtual method
// ----------------------------------------------------------------------------
inline tCIDLib::TVoid TKrnlThread::_SetNotRunning()
{
    __tidThis = kCIDLib::tidInvalid;
}
