//
//  FILE NAME: CIDKernel_TextXlat.Cpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 10/16/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This header contains the user displayable text that is used by the
//  kernel. Because of the low level nature of the kernel, it cannot use
//  the CIDMsg mechanism. So, since its already system specific, we just
//  require that the kernel be recompiled for a new language.
//
//  CAVEATS/GOTCHAS:
//

namespace kMessages
{
    const tCIDLib::Tch* const   pszGen_Unknown          = L"Unknown";
    const tCIDLib::Tch* const   pszGen_Event            = L"Event";
    const tCIDLib::Tch* const   pszGen_Memory           = L"Memory";
    const tCIDLib::Tch* const   pszGen_Mutex            = L"Mutex";
    const tCIDLib::Tch* const   pszGen_Semaphore        = L"Semaphore";

    const tCIDLib::Tch* const   pszErr_OutOfOrder       = L"The error mapping list is not in sorted order!";

    const tCIDLib::Tch* const   pszEnv_CreateCritSec    = L"Creating critical section";
    const tCIDLib::Tch* const   pszEnv_CreateHashMap    = L"Creating hash map";
    const tCIDLib::Tch* const   pszEnv_LoadEnv          = L"Loading environment to hash map";
    const tCIDLib::Tch* const   pszEnv_DeleteCritSec    = L"Deleting critical section";
    const tCIDLib::Tch* const   pszEnv_DeleteHashMap    = L"Deleting hash map";

    const tCIDLib::Tch* const   pszInit_GlobalCtor      = L"Global/static Constructors";
    const tCIDLib::Tch* const   pszInit_ModuleInit      = L"Module Initialization";
    const tCIDLib::Tch* const   pszInit_GlobalDtor      = L"Global/static Destructors";
    const tCIDLib::Tch* const   pszInit_ModuleTerm      = L"Module Termination";
    const tCIDLib::Tch* const   pszInit_KrnlError       = L"A kernel exception occured during DLL init/term. Phase/Reason=";
    const tCIDLib::Tch* const   pszInit_SysError        = L"An unknown system error occured during DLL init/term. Phase/Reason/Error/HostError=";

    const tCIDLib::Tch* const   pszLoc_DefLocale        = L"english-us";
    const tCIDLib::Tch* const   pszLoc_FindDefLoc       = L"Finding default locale in environment";
    const tCIDLib::Tch* const   pszLoc_SetDefLoc        = L"Setting the default locale";

    const tCIDLib::Tch* const   pszMtr_CreateResName    = L"Creating metrics dir resource name object";
    const tCIDLib::Tch* const   pszMtr_CreateMtx        = L"creating/opening the metrics sync mutex";
    const tCIDLib::Tch* const   pszMtr_Locking          = L"locking the metrics sync mutex";
    const tCIDLib::Tch* const   pszMtr_OpenMem          = L"creating/opening the metrics memory";
    const tCIDLib::Tch* const   pszMtr_FreeMem          = L"Could not free the metrics directory during init failure";
    const tCIDLib::Tch* const   pszMtr_DeleteMtx        = L"deleting the metrics mutex";
    const tCIDLib::Tch* const   pszMtr_DelteMem         = L"freeing the metrics memory";
    const tCIDLib::Tch* const   pszMtr_DtorError        = L"Failure during metrics directory destructor";

    const tCIDLib::Tch* const   pszMod_StackDump        = L"Stack Dump";
    const tCIDLib::Tch* const   pszMod_MemCheck         = L"Heap Checking";
    const tCIDLib::Tch* const   pszMod_Module           = L"Module Support";
    const tCIDLib::Tch* const   pszMod_SysInfo          = L"System Information";
    const tCIDLib::Tch* const   pszMod_Environment      = L"Environment Support";
    const tCIDLib::Tch* const   pszMod_Locale           = L"Locale Support";
    const tCIDLib::Tch* const   pszMod_Metrics          = L"Metrics Support";
    const tCIDLib::Tch* const   pszMod_ProcReg          = L"Process Registry";

    const tCIDLib::Tch* const   pszMod_MsgNotFound      = L"The requested message id was not found";
    const tCIDLib::Tch* const   pszMod_NoMsgs           = L"No messages are attached to this module";
    const tCIDLib::Tch* const   pszMod_ResNotFound      = L"Could not load a resource string with the id: ";

    const tCIDLib::Tch* const   pszPReg_Locking         = L"Locking the process registry mutex";
    const tCIDLib::Tch* const   pszPReg_OpenMem         = L"Opening the process registry memory";
    const tCIDLib::Tch* const   pszPReg_InitMem         = L"Initializing the process registry memory";
    const tCIDLib::Tch* const   pszPReg_EntryInit       = L"Initializing our registry entry";
    const tCIDLib::Tch* const   pszPReg_EntryClean      = L"Cleaning up our registry entry";
    const tCIDLib::Tch* const   pszPReg_FreeMem         = L"Could not free the process registry memory";

    const tCIDLib::Tch* const   pszStDump_InitSyms      = L"Failed to init system symbol support";
    const tCIDLib::Tch* const   pszStDump_TraceError    = L"TKrnlThread::StackDump: Failure during stack trace";

    const tCIDLib::Tch* const   pszSysI_QueryOSVer      = L"Could not query OS version info";
    const tCIDLib::Tch* const   pszSysI_OnlyNT          = L"Only the NT platform is supported";
    const tCIDLib::Tch* const   pszSysI_QueryCompName   = L"Could not query computer name";
    const tCIDLib::Tch* const   pszSysI_QueryExeName    = L"Could not get Exe module name";
    const tCIDLib::Tch* const   pszSysI_TooManyParms    = L"Too many command line parameters";

    const tCIDLib::Tch* const   pszThr_CloseHandle      = L"~TKrnlThread: Could not close thread handle";
};
