//
//  FILE NAME: CIDKernel_SystemInfo.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/06/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDKernel_SystemInfo.Cpp module. This
//  module implements the TKrnlSysInfo class. This is a simple class
//  that encapsulates the retrieval of general system information.
//  It will precache info that cannot change for the run of the host
//  process, for faster return. Otherwise, it just gets when asked.
//
//  CAVEATS/GOTCHAS:
//
//  1)  The static data members are set up during DLL init. We have to insure
//      that these fundamental values are in place before any objects
//      construct.
//

#pragma pack(push, CIDLIBPACK)

// ---------------------------------------------------------------------------
//   CLASS: TKrnlSysInfo
//  PREFIX: ksysi
// ---------------------------------------------------------------------------
class KRNLEXPORT TKrnlSysInfo
{
    public  :
        // -------------------------------------------------------------------
        //  Constructors and Destructors
        // -------------------------------------------------------------------
        TKrnlSysInfo();

        ~TKrnlSysInfo();


        // -------------------------------------------------------------------
        //  Public, static methods
        // -------------------------------------------------------------------
        static tCIDLib::TCard4 c4CmdLineArgCount();

        static tCIDLib::TCard4 c4CPUCount();

        static tCIDLib::TCard4 c4SystemColor
        (
            const   tCIDLib::ESysColors     eColor
        );

        static tCIDLib::TCard4 c4TotalPhysicalMem();

        static tCIDLib::ECPUTypes eCPUType();

        static tCIDLib::EEndianModes eEndianMode();

        static tCIDLib::TProcessHandle hprocThis();

        static tCIDLib::TThreadHandle hthrCurrent();

        static tCIDLib::TVoid LoadOSMsg
        (
            const   tCIDLib::TOSErrCode     errcId
            ,       tCIDLib::Tch* const     pszBuffer
            ,       tCIDLib::TCard4&        c4MaxChars
        );

        static tCIDLib::TProcessId pidThis();

        static const tCIDLib::Tch* pszCommandLine();

        static const tCIDLib::Tch* pszNodeName();

        static const tCIDLib::Tch* pszProcessName();

        static tCIDLib::TVoid QueryOSInfo
        (
                    tCIDLib::TCard4&        c4OSMajVersion
            ,       tCIDLib::TCard4&        c4OSMinVersion
            ,       tCIDLib::TCard4&        c4OSBuildNum
        );

        static tCIDLib::TVoid QueryUserName
        (
                    tCIDLib::Tch* const     pszBuffer
            , const tCIDLib::TCard4         c4MaxChars
        );

        static const tCIDLib::Tch* pszCmdLineArg
        (
            const   tCIDLib::TCard4         c4Index
        );

        static tCIDLib::TVoid RemoveCmdLineArg
        (
            const   tCIDLib::TCard4         c4Index
        );

        static tCIDLib::TThreadId tidCurrent();


    private :
        // -------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // -------------------------------------------------------------------
        TKrnlLocale(const TKrnlSysInfo&);

        tCIDLib::TVoid operator=(const TKrnlSysInfo&);


        // -------------------------------------------------------------------
        //  Our module's init method is our friend
        // -------------------------------------------------------------------
        friend tCIDLib::TVoid _InitTermSysInfo
        (
            const   tCIDLib::EInitTerm      eInitTerm
            , const tCIDLib::EGlobalStates  eGlobals
            , const tCIDLib::TModHandle     hModule
            , const tCIDLib::TCard4         c4MaxChars
            ,       tCIDLib::Tch* const     pszFailReason
        );


        // -------------------------------------------------------------------
        //  Private, static data members
        //
        //  __apszArgList
        //      This is storage for the command line parameters.
        //
        //  __c4ArgCnt
        //      This is the number of command line arguments that show to
        //      to the outside world (we strip out the standard ones.)
        //
        //  __c4CPUCount
        //      The number of CPUs in the system, from the OS's perspective.
        //      If the hardware allows some to be taken off line, then I
        //      would assume you would only see the active ones here.
        //
        //  __c4OSBuildNum
        //  __c4OSMajVersion
        //  __c4OSMinVersion
        //      These are all about the version of the OS that we find
        //      ourselves running on.
        //
        //  __c4TotalPhysicalMem
        //      The amount of memory installed in the machine.
        //
        //  __eCPUType
        //      The type of CPUs in this machine. I don't know what will
        //      happen if NT ever supports dissimilar CPU types in the same
        //      machine.
        //
        //  __eEndianMode
        //      The endian mode of the host machine. This is used to know
        //      when to do byte swapping when reading/writing data that is
        //      know to have particular byte orderings.
        //
        //  __hProcess
        //      This is the handle of this process.
        //
        //  __szNodeName
        //      The name assigned to this machine in the system setup. This
        //      size should be grotesquely overkill for any node name.
        //
        //  __szProcessName
        //      The name of the process that this DLL is running in the
        //      context of.
        // -------------------------------------------------------------------
        static  tCIDLib::Tch*           __apszArgList[kCIDLib::c4MaxCmdLineParms];
        static tCIDLib::TCard4          __c4ArgCnt;
        static tCIDLib::TCard4          __c4CPUCount;
        static tCIDLib::TCard4          __c4OSBuildNum;
        static tCIDLib::TCard4          __c4OSMajVersion;
        static tCIDLib::TCard4          __c4OSMinVersion;
        static tCIDLib::TCard4          __c4TotalPhysicalMem;
        static tCIDLib::ECPUTypes       __eCPUType;
        static tCIDLib::EEndianModes    __eEndianMode;
        static tCIDLib::TZStr64         __szNodeName;
        static tCIDLib::TZStr128        __szProcessName;
};

#pragma pack(pop)


// ---------------------------------------------------------------------------
//  Public, static methods
// ---------------------------------------------------------------------------

inline tCIDLib::TCard4 TKrnlSysInfo::c4CPUCount()
{
    return __c4CPUCount;
}

inline tCIDLib::TCard4 TKrnlSysInfo::c4CmdLineArgCount()
{
    return __c4ArgCnt;
}

inline tCIDLib::TCard4 TKrnlSysInfo::c4TotalPhysicalMem()
{
    return __c4TotalPhysicalMem;
}

inline tCIDLib::ECPUTypes TKrnlSysInfo::eCPUType()
{
    return __eCPUType;
}

inline tCIDLib::EEndianModes TKrnlSysInfo::eEndianMode()
{
    return __eEndianMode;
}

inline tCIDLib::TVoid
TKrnlSysInfo::QueryOSInfo(  tCIDLib::TCard4&    c4OSMajVersion
                            , tCIDLib::TCard4&  c4OSMinVersion
                            , tCIDLib::TCard4&  c4OSBuildNum)
{
    c4OSBuildNum    = __c4OSBuildNum;
    c4OSMajVersion  = __c4OSMajVersion;
    c4OSMinVersion  = __c4OSMinVersion;
}
