//
//  FILE NAME: CIDKernel_SysException.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 10/18/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDKernel_SysException.Cpp file. This file
//  implements the TKrnlSysExcept class, which provides a mechanism to write
//  code that must be protected by a system exception (without the need to
//  expose that system specific mechanism to the outside world.)
//
//  A derivative is created that overrides the _bDoWork() method. The
//  public, non-virtual method, DoWork(), puts a system exception handler
//  around the call to _bDoWork().
//
//  _eRecover() is called if an exception occurs, and allows the derived
//  class to decide whether to recover or not.
//
//  CAVEATS/GOTCHAS:
//


// ----------------------------------------------------------------------------
//  Forward references
// ----------------------------------------------------------------------------
struct _EXCEPTION_POINTERS;


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TKrnlSysExcept
//  PREFIX: ksexc
// ----------------------------------------------------------------------------
class KRNLEXPORT TKrnlSysExcept
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructor
        // --------------------------------------------------------------------
        TKrnlSysExcept();

        ~TKrnlSysExcept();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TVoid DoWork();


    protected :
        // --------------------------------------------------------------------
        //  Declare our friends
        // --------------------------------------------------------------------
        friend static tCIDLib::TInt4 __i4Filter
        (
                    TKrnlSysExcept* const   pksexcThis
            , const _EXCEPTION_POINTERS*    pExceptInfo
        );


        // --------------------------------------------------------------------
        //  Protected, virtual methods
        // --------------------------------------------------------------------
        virtual tCIDLib::TVoid _DoWork() = 0;

        virtual tCIDLib::ESysExceptRes _eRecoverTest() = 0;

        virtual tCIDLib::TVoid _Handler() = 0;


        // --------------------------------------------------------------------
        //  Protected, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::ERecoverable _eRecoverable() const;

        tCIDLib::ESysExcepts _eExceptCode() const;

        const tCIDLib::TVoid* _pAddr() const;


    private :
        // --------------------------------------------------------------------
        //  Unimplmented constructors and operators
        // --------------------------------------------------------------------
        TKrnlSysExcept(const TKrnlSysExcept&);

        tCIDLib::TVoid operator=(const TKrnlSysExcept&);


        // --------------------------------------------------------------------
        //  Private data
        //
        //  __eRecoverable
        //      The recoverable state of the exception that caused the
        //      call to _Handler().
        //
        //  __eExceptCode
        //      The exception code that caused the call to _Handler().
        //
        //  __pAddr
        //      The address of the exception that caused the call to 
        //      _Handler().
        // --------------------------------------------------------------------
        tCIDLib::ERecoverable   __eRecoverable;
        tCIDLib::ESysExcepts    __eExceptCode;
        const tCIDLib::TVoid*   __pAddr;
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  Protected, non-virtual methods
// ----------------------------------------------------------------------------

inline tCIDLib::ERecoverable TKrnlSysExcept::_eRecoverable() const
{
    return __eRecoverable;
}

inline tCIDLib::ESysExcepts TKrnlSysExcept::_eExceptCode() const
{
    return __eExceptCode;
}

inline const tCIDLib::TVoid* TKrnlSysExcept::_pAddr() const
{
    return __pAddr;
}
