//
//  FILE NAME: CIDKernel_Semaphore.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 05/01/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDKernel_Semaphore.Cpp module, which implements
//  the TKrnlSemaphore class. This class is the kernel wrapper for the host
//  counting semaphore service. For this NT implementation, it is just a
//  wrapper for the semaphore object handle.
//
//  CAVEATS/GOTCHAS:
//

#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TKrnlSemaphore
//  PREFIX: ksem
// ----------------------------------------------------------------------------
class KRNLEXPORT TKrnlSemaphore
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and destructors
        // --------------------------------------------------------------------
        TKrnlSemaphore
        (
            const   tCIDLib::TCard4         c4MaxCount
        );

        TKrnlSemaphore
        (
            const   tCIDLib::Tch* const     pszName
            , const tCIDLib::TCard4         c4MaxCount
        );

        ~TKrnlSemaphore();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TBoolean bNamed() const;

        tCIDLib::TBoolean bValid() const;

        tCIDLib::TCard4 c4MaxCount() const;

        tCIDLib::TVoid Close();

        tCIDLib::TVoid Create
        (
            const   tCIDLib::TCard4         c4InitCount = 0
        );

        tCIDLib::TVoid CreateOrOpen
        (
            const   tCIDLib::TCard4         c4InitCount = 0
        );

        tCIDLib::TVoid Duplicate
        (
            const   TKrnlSemaphore&         ksemToDup
        );

        tCIDLib::TVoid Enter
        (
            const   tCIDLib::TCard4         c4MilliSecs = kCIDLib::c4MaxWait
        );

        tCIDLib::TVoid Exit();

        const tCIDLib::Tch* pszName() const;

        tCIDLib::TVoid Open();

        tCIDLib::TVoid SetName
        (
            const   tCIDLib::Tch* const     pszNewName
        );


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors or operators
        // --------------------------------------------------------------------
        TKrnlSemaphore();

        TKrnlSemaphore(const TKrnlSemaphore&);

        tCIDLib::TVoid operator=(const TKrnlSemaphore&);


        // -------------------------------------------------------------------
        //  Private, non-virtual methods
        // -------------------------------------------------------------------
        tCIDLib::TVoid __CreateNamed
        (
            const   tCIDLib::TCard4         c4InitCount
            , const tCIDLib::TBoolean       bFailIfExists
        );


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __c4MaxCount
        //      This is the maximum threads that can be in the semaphore at
        //      once.
        //
        //  __hsemThis
        //      This is the handle to the semaphore. It is 0 when not valid.
        //
        //  __pszName
        //      The name of the semaphore.
        // --------------------------------------------------------------------
        tCIDLib::TCard4         __c4MaxCount;
        tCIDLib::TSemHandle     __hsemThis;
        tCIDLib::Tch*           __pszName;

};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  Public, non-virtual methods
// ----------------------------------------------------------------------------

inline tCIDLib::TBoolean TKrnlSemaphore::bNamed() const
{
    return (__pszName != 0);
}

inline tCIDLib::TBoolean TKrnlSemaphore::bValid() const
{
    return (__hsemThis != kCIDLib::hsemInvalid);
}

inline tCIDLib::TCard4 TKrnlSemaphore::c4MaxCount() const
{
    return __c4MaxCount;
}

inline const tCIDLib::Tch* TKrnlSemaphore::pszName() const
{
    return __pszName;
}
