//
// NAME: CIDKernel_SearchNSort.Hpp
//
// DESCRIPTION: 
//
//  This file implements some template based search and sort algorithms for
//  sorting and searching arrays of fundamental values (or objects if they
//  provide the correct operators and are not too piggy to copy by value in
//  the case of the sorts.)
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 02/05/96
//
// COPYRIGHT: 1992..1996, 'CIDCorp
//

namespace CIDSort
{
    //
    //  A recursive quick sort that uses the last element as the target
    //  value for each iteration.
    //
    template <class T>
    tCIDLib::TVoid QSortArray(          T* const            aToSort
                                , const tCIDLib::TCard4     c4Start
                                , const tCIDLib::TCard4     c4End)
    {
        // We are done so don't bother going further
        if (c4Start >= c4End)
            return;

        // Get the starting values for our positions in the array
        tCIDLib::TCard4 c4L = c4Start;
        tCIDLib::TCard4 c4R = c4End;

        // Get the value we want to work towards this time
        T tTarget = aToSort[c4End];

        while (1)
        {
            while (aToSort[c4L] < tTarget)
                c4L++;

            while (aToSort[--c4R] > tTarget)
            {
                if (!c4R)
                    break;
            }

            if (c4L >= c4R)
                break;

            T tTmp = aToSort[c4L];
            aToSort[c4L] = aToSort[c4R];
            aToSort[c4R] = tTmp;
        }

        T tTmp = aToSort[c4L];
        aToSort[c4L] = aToSort[c4End];
        aToSort[c4End] = tTmp;

        if (c4L > c4Start+1)
            QSortArray(aToSort, c4Start, c4L-1);

        if (c4End > c4L+1)
            QSortArray(aToSort, c4L+1, c4End);
    }
}


namespace CIDSearch
{
    //
    //  A simple template method for binary searching a sorted array. If the
    //  element was found, the return is kCIDLib::True and the index of
    //  the element is in c4Index.
    //
    template <class TElem> tCIDLib::TBoolean
    bBinarySearch(  const   TElem               aElems[]
                    , const TElem               ToFind
                    ,       tCIDLib::TCard4&    c4Index
                    , const tCIDLib::TCard4     c4ElemCount)
    {
        // Set up the two end points that are used to subdivide the list
        tCIDLib::TCard4 c4End = c4ElemCount - 1;
        tCIDLib::TCard4 c4Begin = 0;

        while (c4Begin <= c4End)
        {
            // Divide the current range
            tCIDLib::TCard4 c4MidPoint = (c4Begin + c4End) / 2;

            // Check this guy. If this is it, then return the mapped error
            if (ToFind == aElems[c4MidPoint])
            {
                c4Index = c4MidPoint;
                return kCIDLib::True;
            }

            // Didn't find it, so see which way to go and adjust begin/end
            if (ToFind < aElems[c4MidPoint])
                c4End = c4MidPoint - 1;
            else
                c4Begin = c4MidPoint + 1;
        }
        return kCIDLib::False;
    }
}
