//
// NAME: CIDKernel_ScanCodes.Hpp
//
// DESCRIPTION: 
//
//  This file contains constant definitions for the ascii scan codes of
//  keys on the host system. For those very few CIDLib apps that might
//  need to do raw keyboard input, these should be used in order to
//  maintain portability.
//
//  Internally these are used by the TKrnlConsole class to do raw console
//  input and output.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 11/06/95
//
// COPYRIGHT: 1992..1997, CIDCorp
//
// CAVEATS/GOTCHAS: 
//

#if     !defined(HOSTCHTYPE)
#define HOSTCHTYPE tCIDLib::Tch

// ---------------------------------------------------------------------------
//  These are the key scan codes for the letters of the alphabet. They
//  are not preceeded by any leading bytes.
// ---------------------------------------------------------------------------
const HOSTCHTYPE Key_a              = 97;
const HOSTCHTYPE Key_b              = 98;
const HOSTCHTYPE Key_c              = 99;
const HOSTCHTYPE Key_d              = 100;
const HOSTCHTYPE Key_e              = 101;
const HOSTCHTYPE Key_f              = 102;
const HOSTCHTYPE Key_g              = 103;
const HOSTCHTYPE Key_h              = 104;
const HOSTCHTYPE Key_i              = 105;
const HOSTCHTYPE Key_j              = 106;
const HOSTCHTYPE Key_k              = 107;
const HOSTCHTYPE Key_l              = 108;
const HOSTCHTYPE Key_m              = 109;
const HOSTCHTYPE Key_n              = 110;
const HOSTCHTYPE Key_o              = 111;
const HOSTCHTYPE Key_p              = 112;
const HOSTCHTYPE Key_q              = 113;
const HOSTCHTYPE Key_r              = 114;
const HOSTCHTYPE Key_s              = 115;
const HOSTCHTYPE Key_t              = 116;
const HOSTCHTYPE Key_u              = 117;
const HOSTCHTYPE Key_v              = 118;
const HOSTCHTYPE Key_w              = 119;
const HOSTCHTYPE Key_x              = 120;
const HOSTCHTYPE Key_y              = 121;
const HOSTCHTYPE Key_z              = 122;
                                    
const HOSTCHTYPE Key_A              = 65;
const HOSTCHTYPE Key_B              = 66;
const HOSTCHTYPE Key_C              = 67;
const HOSTCHTYPE Key_D              = 68;
const HOSTCHTYPE Key_E              = 69;
const HOSTCHTYPE Key_F              = 70;
const HOSTCHTYPE Key_G              = 71;
const HOSTCHTYPE Key_H              = 72;
const HOSTCHTYPE Key_I              = 73;
const HOSTCHTYPE Key_J              = 74;
const HOSTCHTYPE Key_K              = 75;
const HOSTCHTYPE Key_L              = 76;
const HOSTCHTYPE Key_M              = 77;
const HOSTCHTYPE Key_N              = 78;
const HOSTCHTYPE Key_O              = 79;
const HOSTCHTYPE Key_P              = 80;
const HOSTCHTYPE Key_Q              = 81;
const HOSTCHTYPE Key_R              = 82;
const HOSTCHTYPE Key_S              = 83;
const HOSTCHTYPE Key_T              = 84;
const HOSTCHTYPE Key_U              = 85;
const HOSTCHTYPE Key_V              = 86;
const HOSTCHTYPE Key_W              = 87;
const HOSTCHTYPE Key_X              = 88;
const HOSTCHTYPE Key_Y              = 89;
const HOSTCHTYPE Key_Z              = 90;



// ---------------------------------------------------------------------------
//  These are the key scan codes for the numbers. They are not
//  preceeded by any leading bytes.
// ---------------------------------------------------------------------------
const HOSTCHTYPE Key_0              = 48;
const HOSTCHTYPE Key_1              = 49;
const HOSTCHTYPE Key_2              = 50;
const HOSTCHTYPE Key_3              = 51;
const HOSTCHTYPE Key_4              = 52;
const HOSTCHTYPE Key_5              = 53;
const HOSTCHTYPE Key_6              = 54;
const HOSTCHTYPE Key_7              = 55;
const HOSTCHTYPE Key_8              = 56;
const HOSTCHTYPE Key_9              = 57;



// ---------------------------------------------------------------------------
//  These are the key scan codes for the punctuation marks. They are
//  not preceeded by any leading bytes.
// ---------------------------------------------------------------------------
const HOSTCHTYPE Key_Exclamation    = 33;
const HOSTCHTYPE Key_DoubleQuote    = 34;
const HOSTCHTYPE Key_Pound          = 35;
const HOSTCHTYPE Key_Dollar         = 36;
const HOSTCHTYPE Key_Percent        = 37;
const HOSTCHTYPE Key_Ampersand      = 38;
const HOSTCHTYPE Key_SingleQuote    = 39;
const HOSTCHTYPE Key_OpenParen      = 40;
const HOSTCHTYPE Key_CloseParen     = 41;
const HOSTCHTYPE Key_Asterisk       = 42;
const HOSTCHTYPE Key_Plus           = 43;
const HOSTCHTYPE Key_Comma          = 44;
const HOSTCHTYPE Key_Minus          = 45;
const HOSTCHTYPE Key_Period         = 46;
const HOSTCHTYPE Key_ForwardSlash   = 47;
const HOSTCHTYPE Key_Colon          = 58;
const HOSTCHTYPE Key_SemiColon      = 59;
const HOSTCHTYPE Key_LessThan       = 60;
const HOSTCHTYPE Key_Equal          = 61;
const HOSTCHTYPE Key_GreaterThan    = 62;
const HOSTCHTYPE Key_Question       = 63;
const HOSTCHTYPE Key_At             = 64;
const HOSTCHTYPE Key_OpenBracket    = 91;
const HOSTCHTYPE Key_BackSlash      = 92;
const HOSTCHTYPE Key_CloseBracket   = 93;
const HOSTCHTYPE Key_Caret          = 94;
const HOSTCHTYPE Key_OpenBrace      = 123;
const HOSTCHTYPE Key_CloseBrace     = 125;
const HOSTCHTYPE Key_Tilde          = 126;


// ---------------------------------------------------------------------------
//  These are the scan codes for the non-extended cursor movement
//  keys. They are not preceeded by any leading bytes.
// ---------------------------------------------------------------------------
const HOSTCHTYPE Key_CtrlC          = 3;
const HOSTCHTYPE Key_BS             = 8;
const HOSTCHTYPE Key_Tab            = 9;
const HOSTCHTYPE Key_Enter          = 13;
const HOSTCHTYPE Key_BackTab        = 15;
const HOSTCHTYPE Key_Escape         = 27;
const HOSTCHTYPE Key_Space          = 32;

// ---------------------------------------------------------------------------
//  These are prefix characters which are received before extended key codes.
// ---------------------------------------------------------------------------
const HOSTCHTYPE Key_PadPrefix    = 0;
const HOSTCHTYPE Key_ExtPrefix    = 224;


// ---------------------------------------------------------------------------
//  These are the scan codes for the keypad style keys. These are all
//  prefixed by the pad key prefix value if they are on the keypad. And
//  by the extended prefix if from the other versions of those keys.
// ---------------------------------------------------------------------------
const HOSTCHTYPE Key_Home         = 71;
const HOSTCHTYPE Key_Up           = 72;
const HOSTCHTYPE Key_PageUp       = 73;
const HOSTCHTYPE Key_Left         = 75;
const HOSTCHTYPE Key_Right        = 77;
const HOSTCHTYPE Key_End          = 79;
const HOSTCHTYPE Key_Down         = 80;
const HOSTCHTYPE Key_PageDown     = 81;
const HOSTCHTYPE Key_Insert       = 82;
const HOSTCHTYPE Key_Delete       = 83;


// ---------------------------------------------------------------------------
//  Some common Ctrl-X combinations
// ---------------------------------------------------------------------------
const HOSTCHTYPE Key_CtrlLeft     = 115;
const HOSTCHTYPE Key_CtrlRight    = 116;
const HOSTCHTYPE Key_CtrlEnd      = 117;
const HOSTCHTYPE Key_CtrlHome     = 119;
const HOSTCHTYPE Key_CtrlUp       = 141;
const HOSTCHTYPE Key_CtrlDown     = 145;
const HOSTCHTYPE Key_CtrlIns      = 146;
const HOSTCHTYPE Key_CtrlDel      = 147;


// ---------------------------------------------------------------------------
//  Only available on the keypad, and prefixed by the pad prefix.
// ---------------------------------------------------------------------------
const HOSTCHTYPE Key_Center       = 76;


// ---------------------------------------------------------------------------
//  These are the scan codes for the function keys and their various
//  combinations. These are always prefixed by the pad prefix.
// ---------------------------------------------------------------------------
const HOSTCHTYPE Key_F1           = 59;
const HOSTCHTYPE Key_F2           = 60;
const HOSTCHTYPE Key_F3           = 61;
const HOSTCHTYPE Key_F4           = 62;
const HOSTCHTYPE Key_F5           = 63;
const HOSTCHTYPE Key_F6           = 64;
const HOSTCHTYPE Key_F7           = 65;
const HOSTCHTYPE Key_F8           = 66;
const HOSTCHTYPE Key_F9           = 67;
const HOSTCHTYPE Key_F10          = 68;
const HOSTCHTYPE Key_F11          = 133;
const HOSTCHTYPE Key_F12          = 134;

const HOSTCHTYPE Key_AltF1        = 104;
const HOSTCHTYPE Key_AltF2        = 105;
const HOSTCHTYPE Key_AltF3        = 106;
const HOSTCHTYPE Key_AltF4        = 107;
const HOSTCHTYPE Key_AltF5        = 108;
const HOSTCHTYPE Key_AltF6        = 109;
const HOSTCHTYPE Key_AltF7        = 110;
const HOSTCHTYPE Key_AltF8        = 111;
const HOSTCHTYPE Key_AltF9        = 112;
const HOSTCHTYPE Key_AltF10       = 113;
const HOSTCHTYPE Key_AltF11       = 139;
const HOSTCHTYPE Key_AltF12       = 140;

const HOSTCHTYPE Key_CtrlF1       = 94;
const HOSTCHTYPE Key_CtrlF2       = 95;
const HOSTCHTYPE Key_CtrlF3       = 96;
const HOSTCHTYPE Key_CtrlF4       = 97;
const HOSTCHTYPE Key_CtrlF5       = 98;
const HOSTCHTYPE Key_CtrlF6       = 99;
const HOSTCHTYPE Key_CtrlF7       = 100;
const HOSTCHTYPE Key_CtrlF8       = 101;
const HOSTCHTYPE Key_CtrlF9       = 102;
const HOSTCHTYPE Key_CtrlF10      = 103;
const HOSTCHTYPE Key_CtrlF11      = 137;
const HOSTCHTYPE Key_CtrlF12      = 138;

#undef HOSTCHTYPE
#endif
