//
//  FILE NAME: CIDKernel_SafeCounter.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/11/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This header implements a simple, atomic counter (i.e. its thread safe.)
//
//  CAVEATS/GOTCHAS:
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TKrnlSafeCounter
//  PREFIX: scnt
// ----------------------------------------------------------------------------
class KRNLEXPORT TKrnlSafeCounter
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and Destructors
        // --------------------------------------------------------------------
        TKrnlSafeCounter();

        TKrnlSafeCounter
        (
            const   tCIDLib::TInt4          i4InitVal
        );

        ~TKrnlSafeCounter();


        // --------------------------------------------------------------------
        //  Public, non-virtual methods
        // --------------------------------------------------------------------
        tCIDLib::TBoolean bDec();

        tCIDLib::TBoolean bInc();

        tCIDLib::TInt4 i4AddTo
        (
            const   tCIDLib::TInt4          i4ToAdd
        );

        tCIDLib::TInt4 i4CompareAndExchange
        (
            const   tCIDLib::TInt4          i4New
            , const tCIDLib::TInt4          i4Compare
        );

        tCIDLib::TInt4 i4Exchange
        (
            const   tCIDLib::TInt4          i4New
        );

        tCIDLib::TInt4 i4Value() const;


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TKrnlSafeCounter(const TKrnlSafeCounter&);

        tCIDLib::TVoid operator=(const TKrnlSafeCounter&);


        // --------------------------------------------------------------------
        //  Private data membres
        //
        //  __i4Counter
        //      This is the counter member that is incremented and
        //      decremented.
        // --------------------------------------------------------------------
        tCIDLib::TInt4      __i4Counter;
};

#pragma pack(pop)
