//
//  FILE NAME: CIDKernel_SafeCounter.Cpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/11/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This module implements the the TKrnlSafeCounter class, which is a
//  thread safe counter.
//
//  CAVEATS/GOTCHAS:
//

// ----------------------------------------------------------------------------
//  Includes
// ----------------------------------------------------------------------------
#include    "CIDKernel_.Hpp"


// ----------------------------------------------------------------------------
//   CLASS: TKrnlSafeCounter
//  PREFIX: scnt
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  TKrnlSafeCounter: Constructors and destructors
// ----------------------------------------------------------------------------

TKrnlSafeCounter::TKrnlSafeCounter() :

    __i4Counter(0)
{
}

TKrnlSafeCounter::TKrnlSafeCounter(const tCIDLib::TInt4 i4InitVal) :

    __i4Counter(i4InitVal)
{
}

TKrnlSafeCounter::~TKrnlSafeCounter()
{
}

// ----------------------------------------------------------------------------
//  TKrnlSafeCounter: Public, non-virtual methods
// ----------------------------------------------------------------------------

tCIDLib::TBoolean TKrnlSafeCounter::bDec()
{
    if (!InterlockedDecrement(&__i4Counter))
        return kCIDLib::False;
    return kCIDLib::True;
}

tCIDLib::TBoolean TKrnlSafeCounter::bInc()
{
    if (!InterlockedIncrement(&__i4Counter))
        return kCIDLib::False;
    return kCIDLib::True;
}


tCIDLib::TInt4 TKrnlSafeCounter::i4AddTo(const tCIDLib::TInt4 i4ToAdd)
{
    return InterlockedExchangeAdd(&__i4Counter, i4ToAdd);
}


tCIDLib::TInt4
TKrnlSafeCounter::i4CompareAndExchange( const   tCIDLib::TInt4  i4New
                                        , const tCIDLib::TInt4  i4Compare)
{
    return tCIDLib::TInt4(InterlockedCompareExchange
    (
        (tCIDLib::TVoid**)&__i4Counter
        , (tCIDLib::TVoid*)i4New
        , (tCIDLib::TVoid*)i4Compare
    ));
}


tCIDLib::TInt4 TKrnlSafeCounter::i4Exchange(const tCIDLib::TInt4 i4New)
{
    return InterlockedExchange(&__i4Counter, i4New);
}


tCIDLib::TInt4 TKrnlSafeCounter::i4Value() const
{
    //
    //  Cast away the constness to do this. We will not actually modify
    //  the value, so this is safe, and its the only way to get value
    //  out atomically without modifying it or providing our own sync
    //  mechanism.
    //
    return InterlockedExchangeAdd((tCIDLib::TInt4*)&__i4Counter, 0);
}
