//
//  FILE NAME: CIDKernel_Registry.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/13/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDKernel_Registry.Cpp module. This module
//  implements the TKrnlRegistry class. This class provides access to the
//  registry info of the system. Its relatively well abstracted so it
//  should be fakeable if we port to a system with a different implementation
//  for storing system info.
//
//  We use overloading to allow the user to implicitly indicate what type
//  of data should come back from a particular key. This way we can avoid
//  the overly loose scheme generally used.
//
//  CAVEATS/GOTCHAS:
//
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//  CLASS: TKrnlRegIterator
// PREFIX: kregi
// ----------------------------------------------------------------------------
class KRNLEXPORT TKrnlRegIterator
{
    public  :
        // -------------------------------------------------------------------
        //  Constructors and destructors
        // -------------------------------------------------------------------
        TKrnlRegIterator
        (
            const   tCIDLib::TRegKeyHandle  hrkeyToIterate
        );

        ~TKrnlRegIterator();


        // -------------------------------------------------------------------
        //  Public, non-virtual methods
        // -------------------------------------------------------------------
        tCIDLib::TBoolean bFindNext
        (
                    tCIDLib::Tch* const     pszKeyName
            , const tCIDLib::TCard4         c4BufChars
            ,       tCIDLib::TInt8&         i8LastWrite = NUL_TInt8
        );

        tCIDLib::TVoid Reset();


    private :
        // -------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // -------------------------------------------------------------------
        TKrnlRegIterator();

        TKrnlRegIterator(const TKrnlRegIterator&);

        tCIDLib::TVoid operator=(const TKrnlRegIterator&);


        // -------------------------------------------------------------------
        //  Private data members
        //
        //  __c4Current
        //      This is used to track the current iteration
        //
        //  __hrkeyIter
        //      This is the handle of the registry key we are iterating.
        // -------------------------------------------------------------------
        tCIDLib::TCard4         __c4Current;
        tCIDLib::TRegKeyHandle  __hrkeyIter;
};


// ----------------------------------------------------------------------------
//   CLASS: TKrnlRegistry
//  PREFIX: kreg
// ----------------------------------------------------------------------------
class KRNLEXPORT TKrnlRegistry
{
    public  :
        // -------------------------------------------------------------------
        //  Public, static members
        // -------------------------------------------------------------------
        static const tCIDLib::TRegKeyHandle hrkeyRoot;
        static const tCIDLib::TRegKeyHandle hrkeyCurrentUser;
        static const tCIDLib::TRegKeyHandle hrkeyLocalMachine;
        static const tCIDLib::TRegKeyHandle hrkeyUsers;


        // -------------------------------------------------------------------
        //  Constructors and destructors
        // -------------------------------------------------------------------
        TKrnlRegistry();

        ~TKrnlRegistry();


        // -------------------------------------------------------------------
        //  Public, static methods
        // -------------------------------------------------------------------
        static tCIDLib::TVoid CloseKey
        (
            const   tCIDLib::TRegKeyHandle  hrkeyToClose
        );

        static tCIDLib::TVoid DeleteValue
        (
            const   tCIDLib::TRegKeyHandle  hrkeyTarget
            , const tCIDLib::Tch* const     pszValueName
        );

        static tCIDLib::TVoid DeleteKey
        (
            const   tCIDLib::TRegKeyHandle  hrkeyToDelete
            , const tCIDLib::Tch* const     pszSubKeyName
        );

        static tCIDLib::TVoid FlushKey
        (
            const   tCIDLib::TRegKeyHandle  hrkeyToFlush
        );

        static tCIDLib::TRegKeyHandle hregCreateKey
        (
            const   tCIDLib::TRegKeyHandle  hrkeyParent
            , const tCIDLib::Tch* const     pszSubKey
            , const tCIDLib::Tch* const     pszClass
            , const tCIDLib::ERegFlags      eFlags
            , const tCIDLib::ERegAccessModes eAccessMode
            ,       tCIDLib::TBoolean&      bCreated = NUL_TBoolean
        );

        static tCIDLib::TRegKeyHandle hregOpenKey
        (
            const   tCIDLib::TRegKeyHandle  hrkeyParent
            , const tCIDLib::Tch* const     pszSubKey
            , const tCIDLib::ERegAccessModes eAccessMode
        );

        static tCIDLib::TVoid SetKey
        (
            const   tCIDLib::TRegKeyHandle  hrkeyTarget
            , const tCIDLib::Tch* const     pszValueName
            , const tCIDLib::Tch* const     pszData
        );

        static tCIDLib::TVoid SetKey
        (
            const   tCIDLib::TRegKeyHandle  hrkeyTarget
            , const tCIDLib::Tch* const     pszValueName
            , const tCIDLib::TCard4         c4Data
        );

        static tCIDLib::TVoid SetKey
        (
            const   tCIDLib::TRegKeyHandle  hrkeyTarget
            , const tCIDLib::Tch* const     pszValueName
            , const tCIDLib::TVoid* const   pBuffer
            , const tCIDLib::TCard4         c4DataSz
        );


    private :
        // -------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // -------------------------------------------------------------------
        TKrnlRegistry(const TKrnlRegistry&);

        tCIDLib::TVoid operator=(const TKrnlRegistry&);
};

#pragma pack(pop)
