//
//  FILE NAME: CIDKernel_RawStrings.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/06/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDKernel_RawStrings.Cpp module. This
//  module provides APIs for manipulating raw strings. It deals with
//  the issues of UNICode strings and short strings much more intelligently
//  than the raw system and RTL APIs because it can use C++'s overloading to
//  automatically pick the correct one. Not all of them have every combination,
//  but the important ones do.
//
//  CAVEATS/GOTCHAS:
//

namespace TRawStr
{
    KRNLEXTERN KRNLEXPORT tCIDLib::TBoolean bIsAlpha
    (
        const   tCIDLib::Tch            chToTest
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TBoolean bIsAlpha
    (
        const   tCIDLib::Tsch           schToTest
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TBoolean bIsAlphaNum
    (
        const   tCIDLib::Tch            chToTest
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TBoolean bIsAlphaNum
    (
        const   tCIDLib::Tsch           schToTest
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TBoolean bIsDigit
    (
        const   tCIDLib::Tch            chToTest
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TBoolean bIsDigit
    (
        const   tCIDLib::Tsch           schToTest
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TBoolean bIsLower
    (
        const   tCIDLib::Tch            chToTest
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TBoolean bIsLower
    (
        const   tCIDLib::Tsch           schToTest
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TBoolean bIsPunct
    (
        const   tCIDLib::Tch            chToTest
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TBoolean bIsPunct
    (
        const   tCIDLib::Tsch           schToTest
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TBoolean bIsSpace
    (
        const   tCIDLib::Tch            chToTest
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TBoolean bIsSpace
    (
        const   tCIDLib::Tsch           schToTest
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TBoolean bIsUpper
    (
        const   tCIDLib::Tch            chToTest
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TBoolean bIsUpper
    (
        const   tCIDLib::Tsch           schToTest
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TBoolean bIsHexDigit
    (
        const   tCIDLib::Tch            chToTest
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TBoolean bIsHexDigit
    (
        const   tCIDLib::Tsch           schToTest
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TCard4 c4StrLen
    (
        const   tCIDLib::Tch* const     pszSrc
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TCard4 c4StrLen
    (
        const   tCIDLib::Tsch* const    pszSrc
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::Tch chConvert
    (
        const   tCIDLib::Tsch           schToConvert
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::Tsch schConvert
    (
        const   tCIDLib::Tch            chToConvert
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::Tch chLower
    (
        const   tCIDLib::Tch            chToLower
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::Tsch chLower
    (
        const   tCIDLib::Tsch           schToLower
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::Tch chUpper
    (
        const   tCIDLib::Tch            chToUpper
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::Tsch chUpper
    (
        const   tCIDLib::Tsch           schToUpper
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TCard4 c4AsBinary
    (
        const   tCIDLib::Tch* const     pszToConvert
        , const tCIDLib::ERadices       eRadix
        ,       tCIDLib::TBoolean&      bValid

    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid CatStr
    (
                tCIDLib::Tch* const     pszTarget
        , const tCIDLib::Tch* const     pszSrc
        , const tCIDLib::TCard4         c4MaxChars
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid CatStr
    (
                tCIDLib::Tch* const     pszTarget
        , const tCIDLib::Tsch* const    pszSrc
        , const tCIDLib::TCard4         c4MaxChars
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid CopyCatStr
    (
                tCIDLib::Tch* const     pszTarget
        , const tCIDLib::TCard4         c4MaxChars
        , const tCIDLib::Tch* const     pszCopy
        , const tCIDLib::Tch* const     pszCat
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid CopyCatStr
    (
                tCIDLib::Tch* const     pszTarget
        , const tCIDLib::TCard4         c4MaxChars
        , const tCIDLib::Tch* const     pszCopy
        , const tCIDLib::Tch* const     pszCat1
        , const tCIDLib::Tch* const     pszCat2
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid CopyCatStr
    (
                tCIDLib::Tch* const     pszTarget
        , const tCIDLib::TCard4         c4MaxChars
        , const tCIDLib::Tch* const     pszCopy
        , const tCIDLib::Tch* const     pszCat1
        , const tCIDLib::Tch* const     pszCat2
        , const tCIDLib::Tch* const     pszCat3
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid CopyStr
    (
                tCIDLib::Tch* const     pszTarget
        , const tCIDLib::Tch* const     pszSrc
        , const tCIDLib::TCard4         c4MaxChars
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid CopyStr
    (
                tCIDLib::Tch* const     pszTarget
        , const tCIDLib::Tsch* const    pszSrc
        , const tCIDLib::TCard4         c4MaxChars
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::ESortComps eCompareStr
    (
        const   tCIDLib::Tch* const     pszStr1
        , const tCIDLib::Tch* const     pszStr2
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::ESortComps eCompareStr
    (
        const   tCIDLib::Tsch* const    pszStr1
        , const tCIDLib::Tsch* const    pszStr2
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::ESortComps eNCompareStr
    (
        const   tCIDLib::Tch* const     pszStr1
        , const tCIDLib::Tch* const     pszStr2
        , const tCIDLib::TCard4         c4Count
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::ESortComps eNCompareStr
    (
        const   tCIDLib::Tsch* const    pszStr1
        , const tCIDLib::Tsch* const    pszStr2
        , const tCIDLib::TCard4         c4Count
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::ESortComps eICompareStr
    (
        const   tCIDLib::Tch* const     pszStr1
        , const tCIDLib::Tch* const     pszStr2
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::ESortComps eICompareStr
    (
        const   tCIDLib::Tsch* const    pszStr1
        , const tCIDLib::Tsch* const    pszStr2
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::ESortComps eNICompareStr
    (
        const   tCIDLib::Tch* const     pszStr1
        , const tCIDLib::Tch* const     pszStr2
        , const tCIDLib::TCard4         c4Count
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::ESortComps eNICompareStr
    (
        const   tCIDLib::Tsch* const    pszStr1
        , const tCIDLib::Tsch* const    pszStr2
        , const tCIDLib::TCard4         c4Count
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TFloat8 f8AsBinary
    (
        const   tCIDLib::Tch* const     pszToConvert
        ,       tCIDLib::TBoolean&      bValid
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid FillString
    (
                tCIDLib::Tsch* const    pszBuf
        , const tCIDLib::Tsch           schFill
        , const tCIDLib::TCard4         c4Count
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid FillString
    (
                tCIDLib::Tch* const     pszBuf
        , const tCIDLib::Tch            chFill
        , const tCIDLib::TCard4         c4Count
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid FormatStr
    (
        const   tCIDLib::Tch* const     pszVal
        ,       tCIDLib::Tch* const     pszBuf
        , const tCIDLib::TCard4         c4FldWidth
        , const tCIDLib::Tch            chFill
        , const tCIDLib::EHJustify      eJustify
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid FormatVal
    (
        const   tCIDLib::TCard1         c1Val
        ,       tCIDLib::Tch* const     pszBuf
        , const tCIDLib::TCard4         c4MaxChars
        , const tCIDLib::ERadices       eRadix = tCIDLib::ERadix_Dec
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid FormatVal
    (
        const   tCIDLib::TCard2         c2Val
        ,       tCIDLib::Tch* const     pszBuf
        , const tCIDLib::TCard4         c4MaxChars
        , const tCIDLib::ERadices       eRadix = tCIDLib::ERadix_Dec
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid FormatVal
    (
        const   tCIDLib::TCard4         c4Val
        ,       tCIDLib::Tch* const     pszBuf
        , const tCIDLib::TCard4         c4MaxChars
        , const tCIDLib::ERadices       eRadix = tCIDLib::ERadix_Dec
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid FormatVal
    (
        const   tCIDLib::TInt1          i1Val
        ,       tCIDLib::Tch* const     pszBuf
        , const tCIDLib::TCard4         c4MaxChars
        , const tCIDLib::ERadices       eRadix = tCIDLib::ERadix_Dec
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid FormatVal
    (
        const   tCIDLib::TInt2          i2Val
        ,       tCIDLib::Tch* const     pszBuf
        , const tCIDLib::TCard4         c4MaxChars
        , const tCIDLib::ERadices       eRadix = tCIDLib::ERadix_Dec
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid FormatVal
    (
        const   tCIDLib::TInt4          i4Val
        ,       tCIDLib::Tch* const     pszBuf
        , const tCIDLib::TCard4         c4MaxChars
        , const tCIDLib::ERadices       eRadix = tCIDLib::ERadix_Dec
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid FormatVal
    (
        const   tCIDLib::TUInt          uVal
        ,       tCIDLib::Tch* const     pszBuf
        , const tCIDLib::TCard4         c4MaxChars
        , const tCIDLib::ERadices       eRadix = tCIDLib::ERadix_Dec
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid FormatVal
    (
        const   tCIDLib::TInt8&         i8Val
        ,       tCIDLib::Tch* const     pszBuf
        , const tCIDLib::TCard4         c4MaxChars
        , const tCIDLib::ERadices       eRadix = tCIDLib::ERadix_Dec
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid FormatVal
    (
        const   tCIDLib::TFloat4&       f4Val
        ,       tCIDLib::Tch* const     pszBuf
        , const tCIDLib::TCard4         c4Precision
        , const tCIDLib::TCard4         c4MaxChars
        , const tCIDLib::ETrailFormats  eTrail = tCIDLib::ETrail_Ignore
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid FormatVal
    (
        const   tCIDLib::TFloat8&       f8Val
        ,       tCIDLib::Tch* const     pszBuf
        , const tCIDLib::TCard4         c4Precision
        , const tCIDLib::TCard4         c4MaxChars
        , const tCIDLib::ETrailFormats  eTrail = tCIDLib::ETrail_Ignore
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::THashVal hshHashStr
    (
        const   tCIDLib::Tch* const     pszStr
        , const tCIDLib::TCard4         c4Modulus
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TInt4 i4AsBinary
    (
        const   tCIDLib::Tch* const     pszToConvert
        , const tCIDLib::ERadices       eRadix
        ,       tCIDLib::TBoolean&      bValid

    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TInt8 i8AsBinary
    (
        const   tCIDLib::Tch* const     pszToConvert
        , const tCIDLib::ERadices       eRadix
        ,       tCIDLib::TBoolean&      bValid

    );

    KRNLEXTERN KRNLEXPORT tCIDLib::Tch* pszConvert
    (
        const   tCIDLib::Tsch* const    pszToConvert
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::Tch* pszConvert
    (
        const   tCIDLib::Tsch* const    pszToConvert
        ,       tCIDLib::Tch* const     pszTarget
        , const tCIDLib::TCard4         c4MaxChars
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::Tsch* pszConvert
    (
        const   tCIDLib::Tch* const     pszToConvert
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::Tsch* pszConvert
    (
        const   tCIDLib::Tch* const     pszToConvert
        ,       tCIDLib::Tsch* const    pszTarget
        , const tCIDLib::TCard4         c4MaxChars
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::Tch* pszFindChar
    (
                tCIDLib::Tch* const     pszToSearch
        , const tCIDLib::Tch            chToFind
    );

    KRNLEXTERN KRNLEXPORT const tCIDLib::Tch* pszFindChar
    (
        const   tCIDLib::Tch* const     pszToSearch
        , const tCIDLib::Tch            chToFind
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::Tch* pszFindChars
    (
                tCIDLib::Tch* const     pszSearch
        , const tCIDLib::Tch* const     pszChars
    );

    KRNLEXTERN KRNLEXPORT const tCIDLib::Tch* pszFindChars
    (
        const   tCIDLib::Tch* const     pszSearch
        , const tCIDLib::Tch* const     pszChars
    );

    KRNLEXTERN KRNLEXPORT const tCIDLib::Tch* pszFindLastChar
    (
        const   tCIDLib::Tch* const     pszToSearch
        , const tCIDLib::Tch            chToFind
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::Tch* pszFindLastChar
    (
                tCIDLib::Tch* const     pszToSearch
        , const tCIDLib::Tch            chToFind
    );

    KRNLEXTERN KRNLEXPORT const tCIDLib::Tch* pszFindSubStr
    (
        const   tCIDLib::Tch* const     pszToSearch
        , const tCIDLib::Tch* const     pszToSubStr
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::Tch* pszLoadResString
    (
        const   tCIDLib::TModHandle     hmodSource
        , const tCIDLib::TResId         ridToLoad
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::Tch* pszLowerCase
    (
                tCIDLib::Tch*           pszToLower
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::Tsch* pszLowerCase
    (
                tCIDLib::Tsch*          pszToLower
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::Tch* pszReplicate
    (
        const   tCIDLib::Tch* const     pszToReplicate
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::Tch* pszStrTokenize
    (
                tCIDLib::Tch* const     pszSource
        , const tCIDLib::Tch* const     pszWhitespace
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::Tch* pszUpperCase
    (
                tCIDLib::Tch*           pszToUpper
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::Tsch* pszUpperCase
    (
                tCIDLib::Tsch*          pszToUpper
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid StripStr
    (
                tCIDLib::Tch* const     pszStripBuf
        , const tCIDLib::Tch* const     pszStripChars
        , const tCIDLib::EStripModes    eMode
    );
}
