//
//  FILE NAME: CIDKernel_RawMemory.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/13/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDKernel_RawMemory.Cpp module. This
//  module provides some simple APIs for manipulating raw memory buffers.
//
//  CAVEATS/GOTCHAS:
//


namespace TRawMem
{
    #pragma pack(push, CIDLIBPACK)

    // ------------------------------------------------------------------------
    //  A small structure that is returned by pQueryMemFlags()
    // ------------------------------------------------------------------------
    struct  TSysMemInfo
    {
        tCIDLib::TCard4         c4RegionSize;
        tCIDLib::EMemAccFlags   eAllocAccess;
        tCIDLib::EMemAccFlags   eRegionAccess;
        tCIDLib::EMemStates     eRegionState;
        tCIDLib::EMemTypes      eRegionType;
        tCIDLib::TVoid*         pAllocBase;
    };

    #pragma pack(pop)


    // ------------------------------------------------------------------------
    //  Some primarily internally used flags for dealing with allocation
    //  and commitment of system memory buffers.
    // ------------------------------------------------------------------------
    enum EMemAllFlags
    {
        ECommit                     = 0x00001000UL
        , EReserve                  = 0x00002000UL
    };

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid CommitPages
    (
                tCIDLib::TVoid*         pPageAdr
        , const tCIDLib::TCard4         c4PageCount
        , const tCIDLib::EMemAccFlags   eAccess = tCIDLib::EMemAcc_ReadWrite
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid FreeSysMem
    (
        const   tCIDLib::TVoid*         pBuf
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::ESortComps eCompareMemBuf
    (
        const   tCIDLib::TVoid* const   p1
        , const tCIDLib::TVoid* const   p2
        , const tCIDLib::TCard4         c4Count
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::THashVal hshHashBuffer
    (
        const   tCIDLib::TVoid* const   pBuf
        , const tCIDLib::TCard4         c4Modulus
        , const tCIDLib::TCard4         c4Bytes
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid CopyMemBuf
    (
                tCIDLib::TVoid* const   pDest
        , const tCIDLib::TVoid* const   pSrc
        , const tCIDLib::TCard4         c4Count
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid MoveMemBuf
    (
                tCIDLib::TVoid* const   pDest
        ,       tCIDLib::TVoid* const   pSrc
        , const tCIDLib::TCard4         c4Count
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid* pAllocSysMem
    (
        const   tCIDLib::TCard4         c4Size
        , const tCIDLib::EMemAccFlags   eAccess
        , const TRawMem::EMemAllFlags   eAlloc
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid* pPageBaseAdr
    (
        const   tCIDLib::TVoid*         pBufContained
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid* pCompareAndExchange
    (
                tCIDLib::TVoid*&        pToFill
        , const tCIDLib::TVoid* const   pNew
        , const tCIDLib::TVoid* const   pCompare
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid* pExchange
    (
                tCIDLib::TVoid*&        pToFill
        , const tCIDLib::TVoid* const   pNew
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid* pQueryMemFlags
    (
        const   tCIDLib::TVoid*         pBufToQuery
        ,       TSysMemInfo&            MemInfo
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid SetMemBuf
    (
                tCIDLib::TVoid* const   pMem
        , const tCIDLib::TCard1         c1Fill
        , const tCIDLib::TCard4         c4Count
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid SetMemBuf
    (
                tCIDLib::TVoid* const   pMem
        , const tCIDLib::TCard2         c2Fill
        , const tCIDLib::TCard4         c4Count
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid SetMemBuf
    (
                tCIDLib::TVoid* const   pMem
        , const tCIDLib::TCard4         c4Fill
        , const tCIDLib::TCard4         c4Count
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid SetMemBuf
    (
                tCIDLib::TVoid* const   pMem
        , const tCIDLib::TInt1          i1Fill
        , const tCIDLib::TCard4         c4Count
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid SetMemBuf
    (
                tCIDLib::TVoid* const   pMem
        , const tCIDLib::TInt2          i2Fill
        , const tCIDLib::TCard4         c4Count
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid SetMemBuf
    (
                tCIDLib::TVoid* const   pMem
        , const tCIDLib::TInt4          i4Fill
        , const tCIDLib::TCard4         c4Count
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid SetMemBuf
    (
                tCIDLib::TVoid* const   pMem
        , const tCIDLib::TFloat4        f4Fill
        , const tCIDLib::TCard4         c4Count
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid SetMemBuf
    (
                tCIDLib::TVoid* const   pMem
        , const tCIDLib::TFloat8        f8Fill
        , const tCIDLib::TCard4         c4Count
    );


    //
    //  These are some templates that make the business of doing compare
    //  and exchanges on pointers typesafe and convenient.
    //
    template <class T> T* pExchangePtr(T*& pToFill, const T* const pNew)
    {
        return (T*)pExchange(*(tCIDLib::TVoid**)&pToFill, (tCIDLib::TVoid*)pNew);
    }

    template <class T> T*
    pCompareAndExchangePtr(T*& pToFill, const T* const pNew, const T* const pCompare)
    {
        return (T*)pCompareAndExchange
        (
            *(tCIDLib::TVoid**)&pToFill
            , (tCIDLib::TVoid*)pNew
            , (tCIDLib::TVoid*)pCompare
        );
    }
}
