//
//  FILE NAME: CIDKernel_RawBits.Cpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 09/22/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This module provides a set of methods for manipulating raw bit fields
//  inside various fundamental types. A lot of them are very simple and
//  done as inlines.
//
//  CAVEATS/GOTCHAS:
//

// ----------------------------------------------------------------------------
//  Includes
// ----------------------------------------------------------------------------
#include    "CIDKernel_.Hpp"


// ----------------------------------------------------------------------------
//  Public functions
// ----------------------------------------------------------------------------

tCIDLib::TCard4 TRawBits::c4RotateLeft( const   tCIDLib::TCard4 c4Value
                                        , const tCIDLib::TCard4 c4RotateCount)
{
    tCIDLib::TCard1 c1Rot = tCIDLib::TCard1(c4RotateCount % 32);
    tCIDLib::TCard4 c4Ret = c4Value;

    _asm
    {
        mov     cl, c1Rot
        ROL     c4Ret, cl
    }
    return c4Ret;
}

tCIDLib::TCard4 TRawBits::c4RotateRight(const   tCIDLib::TCard4 c4Value
                                        , const tCIDLib::TCard4 c4RotateCount)
{
    tCIDLib::TCard1 c1Rot = tCIDLib::TCard1(c4RotateCount % 32);
    tCIDLib::TCard4 c4Ret = c4Value;

    _asm
    {
        mov     cl, c1Rot
        ROR     c4Ret, cl
    }
    return c4Ret;
}
