//
//  FILE NAME: CIDKernel_ObjJanitor.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/10/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This header implements a very simple template class that provides
//  janitorial services for any type of object.
//
//  CAVEATS/GOTCHAS:
//


#pragma pack(push, CIDLIBPACK)

// -----------------------------------------------------------------------------
//   CLASS: TJanitor
//  PREFIX: jan
// -----------------------------------------------------------------------------
template <class T> class TJanitor
{
    public  :
        // ---------------------------------------------------------------------
        //  Constructors and Destructors
        // ---------------------------------------------------------------------
        TJanitor
        (
                    T* const                pobjToDelete
        );

        ~TJanitor();


        // ---------------------------------------------------------------------
        //  Public, non-virtual methods
        // ---------------------------------------------------------------------
        tCIDLib::TVoid Orphan();


    private :
        // ---------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // ---------------------------------------------------------------------
        TJanitor();

        TJanitor(const TJanitor<T>&);

        tCIDLib::TVoid operator=(const TJanitor<T>&);


        // ---------------------------------------------------------------------
        //  Private data members
        //
        //  __pobjToSanitize
        //      This is the pointer to the object that must be destroyed
        //      when this object is destroyed.
        // ---------------------------------------------------------------------
        T*  __pobjToSanitize;
};

#pragma pack(pop)


// -----------------------------------------------------------------------------
//  Constructors and destructors
// -----------------------------------------------------------------------------
template <class T> TJanitor<T>::TJanitor(T* const pobjToDelete) :

    __pobjToSanitize(pobjToDelete)
{
}

template <class T> TJanitor<T>::~TJanitor()
{
    delete __pobjToSanitize;
    __pobjToSanitize = 0;
}

// -----------------------------------------------------------------------------
//  Public, non-virtual methods
// -----------------------------------------------------------------------------
template <class T> tCIDLib::TVoid TJanitor<T>::Orphan()
{
    __pobjToSanitize = 0;
}
