//
//  FILE NAME: CIDKernel_MsgFileSupport.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 09/02/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is a special header that is used internally and by the MakeMsgs.Exe
//  program. It contains some ids and APIs used to store CIDLib messages in
//  the resource area of a DLL or Exe.
//
//  CAVEATS/GOTCHAS:
//
//  1)  This file is not normally included. It must be explicitly included
//      by the programs/files that need it.
//

namespace kMsgFileIds
{
    const   tCIDLib::TCard4     c4Language      = 0x200;
    const   tCIDLib::TCard4     c4SubLanguage   = 0x20;

    const   tCIDLib::TCard4     c4ResType       = 0x1000;
    const   tCIDLib::TCard4     c4ResId         = 1;
};


namespace CIDMsgFile
{
    // ------------------------------------------------------------------------
    //  The format of index entries in a CIDMsg binary message file.
    // ------------------------------------------------------------------------
    #pragma pack(push,2)
    struct TMsgIndexEntry
    {
        tCIDLib::TMsgId                 midThis;
        tCIDLib::TCard4                 c4TextOffset;
        tCIDLib::TCard2                 c2TextChars;
    };

    struct TMsgIndex
    {
        tCIDLib::TCard4                 c4MsgCount;
        TMsgIndexEntry                  amieList[1];
    };
    #pragma pack(pop)

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid UpdateMsgResource
    (
        const   tCIDLib::Tch* const     pszFileName
        , const tCIDLib::TCard1* const  pc1BufData
        , const tCIDLib::TCard4         c4BufSize
    );
};
