//
// NAME: CIDKernel_MsgFileSupport.Cpp
//
// DESCRIPTION:
//
//	This module provides some special message file support APIs. It is for
//  internal use only, and for the MakeMsgs.Exe utility.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 09/02/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// ----------------------------------------------------------------------------
//  Facility specific includes
// ----------------------------------------------------------------------------
#include    "CIDKernel_.Hpp"
#include    "CIDKernel_MsgFileSupport.Hpp"


tCIDLib::TVoid 
CIDMsgFile::UpdateMsgResource(  const  tCIDLib::Tch* const     pszFileName
                                , const tCIDLib::TCard1* const  pc1BufData
                                , const tCIDLib::TCard4         c4BufSize)
{
    //
    //  Get a handle to update the resources on the target Exe file. If
    //  the target file is not valid, it will check for us so we don't bother
    //  confirming it first.
    //
    tCIDLib::THandle hrscUpdate = ::BeginUpdateResourceW(pszFileName, 0);
    if (!hrscUpdate)
        TKrnlError::ThrowKrnlError();

    try
    {
        if (!::UpdateResourceW
        (
            hrscUpdate
            , MAKEINTRESOURCE(kMsgFileIds::c4ResType)
            , MAKEINTRESOURCE(kMsgFileIds::c4ResId)
            , MAKELANGID(kMsgFileIds::c4Language, kMsgFileIds::c4SubLanguage)
            , (tCIDLib::TVoid*)pc1BufData
            , c4BufSize))
        {
            TKrnlError::ThrowKrnlError();
        }
    }

    catch(...)
    {
        ::EndUpdateResource(hrscUpdate, 1);
        throw;
    }

    if (!::EndUpdateResource(hrscUpdate, 0))
        TKrnlError::ThrowKrnlError();
}
