//
//  FILE NAME: CIDKernel_Module.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 11/22/96
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDKernel_Module.Cpp module. This module
//  implements the TKrnlModule class, which encapsulates the concept of
//  a loadable module (Exe or Dll) and the things that you do via it.
//
//
//  CAVEATS/GOTCHAS:
//
//  1)  The LoadFromName() loads a module, and should be used for
//      dynamic loading. QueryFromName just queries the handle for an
//      existing loaded module.
//
//  2)  Access is given to the raw module handle, but using it is not
//      suggested due to portability concerns.
//
//  3)  The constructor that takes a module name does a load or a query
//      according to the bLoad parameter. The one that takes the handle uses
//      the flag to know how the handle was created, so it can do the right
//      thing to clean it up.
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TKrnlModule
//  PREFIX: kmod
// ----------------------------------------------------------------------------
class KRNLEXPORT TKrnlModule
{
    public  :
        // -------------------------------------------------------------------
        //  Constructors and destructors
        // -------------------------------------------------------------------
        TKrnlModule();

        TKrnlModule
        (
            const   tCIDLib::Tch* const     pszName
            , const tCIDLib::EModTypes      eModType
            , const tCIDLib::TBoolean       bLoad = kCIDLib::False
        );

        TKrnlModule
        (
            const   tCIDLib::TModHandle     hmodToUse
            , const tCIDLib::EAdoptOpts     eAdopt = tCIDLib::EAdoptOpt_NoAdopt
            , const tCIDLib::TBoolean       bViaLoad = kCIDLib::False
        );

        ~TKrnlModule();


        // -------------------------------------------------------------------
        //  Public, static methods
        // -------------------------------------------------------------------
        static const tCIDLib::Tch* pszRawLoadCIDMsg
        (
            const   tCIDLib::TModHandle     hmodSource
            , const tCIDLib::TMsgId         midToLoad
        );

        static tCIDLib::TVoid RawQueryModName
        (
            const   tCIDLib::TModHandle     hmodToQuery
            ,       tCIDLib::Tch* const     pszToFill
            , const tCIDLib::TCard4         c4MaxChars
        );


        // -------------------------------------------------------------------
        //  Public, non-virtual methods
        // -------------------------------------------------------------------
        tCIDLib::TVoid AdoptHandle
        (
            const   tCIDLib::TModHandle     hModule
            , const tCIDLib::TBoolean       bViaLoad = kCIDLib::False
        );

        tCIDLib::TBoolean bLoadCIDMsg
        (
            const   tCIDLib::TMsgId         midToLoad
            ,       tCIDLib::Tch* const     pszTarget
            , const tCIDLib::TCard4         c4MaxChars
        )   const;

        tCIDLib::TBoolean bLoadResString
        (
            const   tCIDLib::TResId         ridToLoad
            ,       tCIDLib::Tch* const     pszTarget
            , const tCIDLib::TCard4         c4MaxChars
        )   const;

        tCIDLib::TCard4 c4QueryResourceSize
        (
            const   tCIDLib::ERscTypes      eRscType
            , const tCIDLib::TResId         ridToQuery
        )   const;

        tCIDLib::TVoid DeleteBitmap
        (
            const   tCIDLib::TBmpHandle     hbmpToDelete
        )   const;

        tCIDLib::EAdoptOpts eAdopted() const;

        tCIDLib::TVoid FreeResource
        (
                    tCIDLib::TVoid*         pResource
        )   const;

        tCIDLib::TModHandle hmodThis() const;

        tCIDLib::TBmpHandle LoadBitmap
        (
            const   tCIDLib::TResId         ridBitmap
        )   const;

        tCIDLib::TVoid LoadFromName
        (
            const   tCIDLib::Tch* const     pszModuleName
            , const tCIDLib::EModTypes      eModType
        );

        tCIDLib::TBmpHandle LoadSysBitmap
        (
            const   tCIDLib::ESysBitmaps    eBitmap
        )   const;

        tCIDLib::TVoid* pLoadResource
        (
            const   tCIDLib::ERscTypes      eRscType
            , const tCIDLib::TResId         ridToLoad
        )   const;

        const tCIDLib::Tch* pszLoadCIDMsg
        (
            const   tCIDLib::TMsgId         midToLoad
            ,       tCIDLib::TBoolean&      bLoaded = NUL_TBoolean
        )   const;

        const tCIDLib::Tch* pszLoadResString
        (
            const   tCIDLib::TResId         ridToLoad
            ,       tCIDLib::TBoolean&      bLoaded = NUL_TBoolean
        )   const;

        tCIDLib::TVoid QueryFromName
        (
            const   tCIDLib::Tch* const     pszModuleName
            , const tCIDLib::EModTypes      eModType
        );


    private :
        // -------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // -------------------------------------------------------------------
        TKrnlModule(const TKrnlModule&);

        tCIDLib::TVoid operator=(const TKrnlModule&);


        // -------------------------------------------------------------------
        //  Private, non-virtual methods
        // -------------------------------------------------------------------
        tCIDLib::TVoid __ClearHandle();

        tCIDLib::TVoid __LoadMessages();

        tCIDLib::TCard4 __c4QueryStringResourceSize
        (
            const   tCIDLib::TResId         ridToQuery
        )   const;


        // -------------------------------------------------------------------
        //  Private data members
        //
        //  __bViaLoad
        //      Indicates whether the module handle was obtained by loading
        //      the library or just querying the handle of an existing
        //      one.  If loaded, we free it when the handle is destroyed.
        //
        //  __eAdopted
        //      Indicates whether the handle is adopted or whether we are
        //      just referencing it.
        //
        //  __hmodThis
        //      The handle of the module that we are controlling.
        //
        //  __pMsgData
        //      This is a pointer to the message file data for this module,
        //      if there are any. If not, then its 0. Its seen as a TVoid*
        //      here but internally it is understood.
        // -------------------------------------------------------------------
        tCIDLib::TBoolean       __bViaLoad;
        tCIDLib::EAdoptOpts     __eAdopted;
        tCIDLib::TModHandle     __hmodThis;
        tCIDLib::TVoid*         __pMsgData;
};

#pragma pack(pop)


// ----------------------------------------------------------------------------
//  Public, non-static methods
// ----------------------------------------------------------------------------

inline tCIDLib::EAdoptOpts TKrnlModule::eAdopted() const
{
    return __eAdopted;
}

inline tCIDLib::TModHandle TKrnlModule::hmodThis() const
{
    return __hmodThis;
}
