//
//  FILE NAME: CIDKernel_MemCheck.Hpp
//
//     AUTHOR: Dean Roddey
//
//    CREATED: 08/13/97
//
//  COPYRIGHT: 1992..1997, 'CIDCorp
//
//  DESCRIPTION:
//
//  This is the header for the CIDKernel_MemCheck.Cpp module. It implements
//  the TKrnlMemCheck class, which is an abstraction for the host memory
//  debugging tools.
//
//  Its only for use in testing programs. The constructor will take a snap
//  show. The destructor will, if differences exist, dump the differences
//  between them.
//
//  CAVEATS/GOTCHAS:
//


#pragma pack(push, CIDLIBPACK)

// ----------------------------------------------------------------------------
//   CLASS: TKrnlMemCheck
//  PREFIX: kmchk
// ----------------------------------------------------------------------------
class KRNLEXPORT TKrnlMemCheck
{
    public  :
        // --------------------------------------------------------------------
        //  Constructors and destructors
        // --------------------------------------------------------------------
        TKrnlMemCheck();

        ~TKrnlMemCheck();


        // --------------------------------------------------------------------
        //  Public, static method
        // --------------------------------------------------------------------
        static tCIDLib::TVoid ReportToFile
        (
            const   TKrnlFile&              kflTarget
        );

        static tCIDLib::TVoid ValidateHeap();


    private :
        // --------------------------------------------------------------------
        //  Unimplemented constructors and operators
        // --------------------------------------------------------------------
        TKrnlMemCheck(const TKrnlMemCheck&);

        tCIDLib::TVoid operator=(const TKrnlMemCheck&);


        // --------------------------------------------------------------------
        //  Private data members
        //
        //  __pSnapShot
        //      This a shapshot buffer. Its non-typed here, and seen as its
        //      real type internally.
        // --------------------------------------------------------------------
        tCIDLib::TVoid*     __pSnapShot;
};

#pragma pack(pop)
