//
// NAME: CIDKernel_MemCheck.Cpp
//
// DESCRIPTION:
//
//	This module implements the TKrnlMemCheck class, which is a simple
//  abstraction for the host development environment or OS heap debugging
//  services.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 08/13/97
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//


// ----------------------------------------------------------------------------
//  Facility specific includes
// ----------------------------------------------------------------------------
#include    "CIDKernel_.Hpp"
#include    "CIDKernel_MemCheck.Hpp"
#include    <crtdbg.h>



// ----------------------------------------------------------------------------
//  Intra-facility functions
// ----------------------------------------------------------------------------

tCIDLib::TVoid
_InitTermMemCheck(  const   tCIDLib::EInitTerm      eInitTerm
                    , const tCIDLib::EGlobalStates  eGlobals
                    , const tCIDLib::TModHandle     hmodThis
                    , const tCIDLib::TCard4         c4MaxChars
                    ,       tCIDLib::Tch* const     pszFailReason)
{
    #if CID_DEBUG_ON
    //
    //  If we are debugging, then set up the way that the memory debugging
    //  stuff does its reports.
    //
    if ((eInitTerm == tCIDLib::EInitTerm_Initialize)
    &&  (eGlobals == tCIDLib::EGlobalState_Before))
    {
        _CrtSetReportMode(_CRT_ERROR, _CRTDBG_MODE_FILE);
        _CrtSetReportFile(_CRT_ERROR, _CRTDBG_FILE_STDERR);
        _CrtSetReportMode(_CRT_WARN, _CRTDBG_MODE_FILE);
        _CrtSetReportFile(_CRT_WARN, _CRTDBG_FILE_STDERR);
    }
    #endif
}



// ----------------------------------------------------------------------------
//   CLASS: TKrnlMemCheck
//  PREFIX: kmchk
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
//  TKrnlMemCheck: Constructors and destructors
// ----------------------------------------------------------------------------

TKrnlMemCheck::TKrnlMemCheck() :

    __pSnapShot(0)
{
    #if CID_DEBUG_ON
    // Allocate a memory state structure and take a snapshot
    __pSnapShot = new _CrtMemState;
    _CrtMemCheckpoint((_CrtMemState*)__pSnapShot);
    #endif
}

TKrnlMemCheck::~TKrnlMemCheck()
{
    #if CID_DEBUG_ON

    // Take another snap shot now
    _CrtMemState SnapShot;
    _CrtMemCheckpoint(&SnapShot);

    // If there are differences, dump them out
    _CrtMemState Diffs;
    if (_CrtMemDifference(&Diffs, (_CrtMemState*)__pSnapShot, &SnapShot))
        _CrtMemDumpStatistics(&Diffs);

    // And now clean up the buffer
    delete __pSnapShot;

    #endif
}


// ----------------------------------------------------------------------------
//  TKrnlMemCheck: Public, static methods
// ----------------------------------------------------------------------------

tCIDLib::TVoid TKrnlMemCheck::ReportToFile(const TKrnlFile& kflTarget)
{
    if (&kflTarget)
        _CrtSetReportFile(_CRT_WARN, kflTarget.hflThis());
    else
        _CrtSetReportFile(_CRT_WARN, _CRTDBG_FILE_STDERR);
}

tCIDLib::TVoid TKrnlMemCheck::ValidateHeap()
{
    _CrtCheckMemory();
}
