//
// NAME: CIDMath_Lib.Hpp
//
// DESCRIPTION: 
//
//  This file just maps the C runtime math routines to different names that
//  meet the CIDLib naming standards. This will allow them to eventually
//  be changed to support other libraries or written in assembly.
//
//
// AUTHOR: Dean Roddey
//
// CREATE DATE: 05/02/94
//
// COPYRIGHT: 1992..1997, 'CIDCorp
//
// CAVEATS/GOTCHAS: 
//

namespace TMathLib
{
    // ------------------------------------------------------------------------
    //  Coordinate functions
    // ------------------------------------------------------------------------
    inline tCIDLib::TFloat8 f8ToDegrees(const tCIDLib::TFloat8 f8Radians)
    {
        return f8Radians * (180.0 / kCIDLib::f8PI);
    }

    inline  tCIDLib::TFloat8 f8ToRadians(const tCIDLib::TFloat8 f8Degrees)
    {
        return f8Degrees * (kCIDLib::f8PI / 180.0);
    }



    // ------------------------------------------------------------------------
    //  Log functions
    // ------------------------------------------------------------------------
    KRNLEXTERN KRNLEXPORT tCIDLib::TFloat8 f8Log10(const tCIDLib::TFloat8 f8Value);

    KRNLEXTERN KRNLEXPORT tCIDLib::TFloat8 f8Log(const tCIDLib::TFloat8 f8Value);



    // ------------------------------------------------------------------------
    //  Geometrical functions
    // ------------------------------------------------------------------------
    KRNLEXTERN KRNLEXPORT tCIDLib::TFloat8 f8Hypotenuse
    (
        const   tCIDLib::TFloat8    f8X
        , const tCIDLib::TFloat8    f8Y
    );



    // ------------------------------------------------------------------------
    //  Miscellaneous functions
    // ------------------------------------------------------------------------
    KRNLEXTERN KRNLEXPORT tCIDLib::TFloat8 f8Abs(const tCIDLib::TFloat8 f8Value);

    KRNLEXTERN KRNLEXPORT tCIDLib::TFloat8 f8Exponent(const tCIDLib::TFloat8 f8Value);

    KRNLEXTERN KRNLEXPORT tCIDLib::TFloat8 f8Floor(const tCIDLib::TFloat8 f8Value);

    KRNLEXTERN KRNLEXPORT tCIDLib::TFloat8 f8Mod
    (
        const   tCIDLib::TFloat8    f8Value
        , const tCIDLib::TFloat8    f8Divisor
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TFloat8 f8Power
    (
        const   tCIDLib::TFloat8    f8Value
        , const tCIDLib::TFloat8    f8Power
    );

    KRNLEXTERN KRNLEXPORT tCIDLib::TFloat8 f8Split
    (
        const   tCIDLib::TFloat8    f8Value
        ,       tCIDLib::TFloat8&   f8Integral
    );



    // ------------------------------------------------------------------------
    //  Transcendental functions
    // ------------------------------------------------------------------------
    KRNLEXTERN KRNLEXPORT tCIDLib::TFloat8 f8ArcCosine(const tCIDLib::TFloat8 f8Value);

    KRNLEXTERN KRNLEXPORT tCIDLib::TFloat8 f8ArcSine(const tCIDLib::TFloat8 f8Value);

    KRNLEXTERN KRNLEXPORT tCIDLib::TFloat8 f8Cosine(const tCIDLib::TFloat8 f8Value);

    KRNLEXTERN KRNLEXPORT tCIDLib::TFloat8 f8HyperCosine(const tCIDLib::TFloat8 f8Value);

    KRNLEXTERN KRNLEXPORT tCIDLib::TFloat8 f8HyperSine(const tCIDLib::TFloat8 f8Value);

    KRNLEXTERN KRNLEXPORT tCIDLib::TFloat8 f8HyperTangent(const tCIDLib::TFloat8 f8Value);

    KRNLEXTERN KRNLEXPORT tCIDLib::TFloat8 f8Sine(const tCIDLib::TFloat8 f8Value);

    KRNLEXTERN KRNLEXPORT tCIDLib::TFloat8 f8Square(const tCIDLib::TFloat8 f8Value);

    KRNLEXTERN KRNLEXPORT tCIDLib::TFloat8 f8SqrRoot(const tCIDLib::TFloat8 f8Value);

    KRNLEXTERN KRNLEXPORT tCIDLib::TFloat8 f8Tangent(const tCIDLib::TFloat8 f8Value);


    // ------------------------------------------------------------------------
    //  Random number functions
    // ------------------------------------------------------------------------
    KRNLEXTERN KRNLEXPORT tCIDLib::TCard4 c4RandomNum();

    KRNLEXTERN KRNLEXPORT tCIDLib::TVoid SeedRandom(const tCIDLib::TCard4 c4Seed);
};
